/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.race.slime;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.registry.item.TrItems;
import com.github.dominickwd04.traddon.registry.race.TrRaces;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.slime.SlimeRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class DarkSlimeRace
extends SlimeRace {
    public DarkSlimeRace() {
        super(Race.Difficulty.EASY);
    }

    public double getBaseHealth() {
        return 100.0;
    }

    public double getBaseAttackDamage() {
        return 1.0;
    }

    public double getBaseAttackSpeed() {
        return 4.2;
    }

    public double getKnockbackResistance() {
        return 0.4;
    }

    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)2.0);
    }

    public double getMovementSpeed() {
        return 0.1;
    }

    public double getSprintSpeed() {
        return 0.15;
    }

    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)3000.0, (Object)3000.0);
    }

    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)7000.0, (Object)7000.0);
    }

    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List list = super.getIntrinsicSkills(player);
        ((List)TrConfig.INSTANCE.racesConfig.darkSlimeSkills.get()).forEach(skill -> {
            if (!skill.equals("")) {
                list.add((TensuraSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill)));
            }
        });
        return list;
    }

    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ABYSS_SLIME));
        return list;
    }

    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ABYSS_SLIME);
    }

    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ABYSS_SLIME);
    }

    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.SLIME.get());
        list.add((Race)TensuraRaces.METAL_SLIME.get());
        return list;
    }

    public double getEvolutionPercentage(Player player) {
        int essence = 0;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            essence = localPlayer.m_108630_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TrItems.ABYSS_CORE.get())));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            essence = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TrItems.ABYSS_CORE.get())));
        }
        return essence * 100;
    }

    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.consume_requirement", (Object[])new Object[]{Component.m_237115_((String)"item.traddon.abyss_core").m_130940_(ChatFormatting.DARK_PURPLE)}));
        return list;
    }
}

