/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.race.slime;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.race.slime.AbyssSlimeRace;
import com.github.dominickwd04.traddon.registry.race.TrRaces;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;

public class EldritchSlimeRace
extends AbyssSlimeRace {
    @Override
    public double getBaseHealth() {
        return 4000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 5.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.8;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)4.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.4;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 6.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1000000.0, (Object)1000000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1000000.0, (Object)1000000.0);
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP((Player)player) * 100.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToDivine.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ABYSS_SLIME));
        return list;
    }

    public boolean isDivine() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        ((List)TrConfig.INSTANCE.racesConfig.eldritchSlimeSkills.get()).forEach(skill -> list.add((TensuraSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))));
        return list;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }
}

