/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings;

import me.bloodred.extragreetings.bstats.bukkit.Metrics;
import me.bloodred.extragreetings.commands.ExtraGreetingsCommand;
import me.bloodred.extragreetings.commands.LegacyCommandRegistrar;
import me.bloodred.extragreetings.commands.PaperCommandRegistrar;
import me.bloodred.extragreetings.config.ConfigManager;
import me.bloodred.extragreetings.listeners.PlayerEventListener;
import me.bloodred.extragreetings.managers.BossBarManager;
import me.bloodred.extragreetings.managers.CooldownManager;
import me.bloodred.extragreetings.managers.FirstJoinManager;
import me.bloodred.extragreetings.utils.PlaceholderUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ExtraGreetings
extends JavaPlugin {
    private static final String PREFIX = "<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> ";
    private static ExtraGreetings instance;
    private ConfigManager configManager;
    private BossBarManager bossBarManager;
    private CooldownManager cooldownManager;
    private FirstJoinManager firstJoinManager;
    private PlaceholderUtils placeholderUtils;
    private ExtraGreetingsCommand commandHandler;
    private boolean placeholderAPIEnabled = false;
    private boolean debugMode = false;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.sendColoredMessage("Enabling ExtraGreetings!!!\n<#FF00A8><bold>\u2554\u2550\u2550\u2550\u2557\u2500\u2500\u2554\u2557\u2500\u2500\u2500\u2500\u2500\u2554\u2550\u2550\u2550\u2557\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2554\u2557\n\u2551\u2554\u2550\u2550\u255d\u2500\u2554\u255d\u255a\u2557\u2500\u2500\u2500\u2500\u2551\u2554\u2550\u2557\u2551\u2500\u2500\u2500\u2500\u2500\u2500\u2554\u255d\u255a\u2557\n\u2551\u255a\u2550\u2550\u2566\u2557\u2560\u2557\u2554\u256c\u2550\u2566\u2550\u2550\u2563\u2551\u2500\u255a\u256c\u2550\u2566\u2550\u2550\u2566\u2550\u2569\u2557\u2554\u256c\u2566\u2550\u2557\u2554\u2550\u2550\u2566\u2550\u2550\u2557\n\u2551\u2554\u2550\u2550\u2569\u256c\u256c\u2563\u2551\u2551\u2554\u2563\u2554\u2557\u2551\u2551\u2554\u2550\u2563\u2554\u2563\u2551\u2550\u2563\u2551\u2550\u2563\u2551\u2560\u2563\u2554\u2557\u2563\u2554\u2557\u2551\u2550\u2550\u2563\n\u2551\u255a\u2550\u2550\u2566\u256c\u256c\u2563\u255a\u2563\u2551\u2551\u2554\u2557\u2551\u255a\u2569\u2550\u2551\u2551\u2551\u2551\u2550\u2563\u2551\u2550\u2563\u255a\u2563\u2551\u2551\u2551\u2551\u255a\u255d\u2560\u2550\u2550\u2551\n\u255a\u2550\u2550\u2550\u2569\u255d\u255a\u2569\u2550\u2569\u255d\u255a\u255d\u255a\u2569\u2550\u2550\u2550\u2569\u255d\u255a\u2550\u2550\u2569\u2550\u2550\u2569\u2550\u2569\u2569\u255d\u255a\u2569\u2550\u2557\u2560\u2550\u2550\u255d\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2554\u2550\u255d\u2551\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u255a\u2550\u2550\u255d</bold></#FF00A8>");
        this.configManager = new ConfigManager(this);
        this.bossBarManager = new BossBarManager();
        this.cooldownManager = new CooldownManager();
        this.firstJoinManager = new FirstJoinManager(this);
        this.placeholderUtils = new PlaceholderUtils(this);
        this.loadConfiguration();
        this.placeholderUtils.initialize();
        this.checkPlaceholderAPI();
        this.registerPermissions();
        this.registerEvents();
        this.commandHandler = new ExtraGreetingsCommand(this);
        this.registerCommands();
        this.initializeMetrics();
        this.sendColoredMessage("ExtraGreetings v" + this.getDescription().getVersion() + " has been enabled!");
        this.sendColoredMessage("PlaceholderAPI support: " + (this.placeholderAPIEnabled ? "Enabled" : "Disabled"));
    }

    public void onDisable() {
        if (this.bossBarManager != null) {
            this.bossBarManager.cleanup();
        }
        if (this.firstJoinManager != null) {
            this.firstJoinManager.saveData();
        }
        this.sendColoredMessage("ExtraGreetings has been disabled!");
    }

    private void loadConfiguration() {
        try {
            this.configManager.loadConfig();
            this.debugMode = this.configManager.getConfig().getBoolean("settings.debug", false);
            this.logDebug("Configuration loaded successfully");
        }
        catch (Exception e) {
            this.sendColoredMessage("<red>Failed to load configuration!</red>\n<#FF0000>" + String.valueOf(e));
        }
    }

    private void checkPlaceholderAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderAPIEnabled = true;
            this.sendColoredMessage("PlaceholderAPI found! Placeholder support enabled.");
        } else {
            this.sendColoredMessage("PlaceholderAPI not found. Using built-in placeholders only.");
        }
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        this.logDebug("Event listeners registered");
    }

    private void registerPermissions() {
        this.getServer().getPluginManager().addPermission(new Permission("extragreetings.admin", "Access to ExtraGreetings admin commands", PermissionDefault.OP));
        this.getServer().getPluginManager().addPermission(new Permission("extragreetings.vip", "VIP greeting permissions", PermissionDefault.FALSE));
        this.getServer().getPluginManager().addPermission(new Permission("extragreetings.bypass.cooldown", "Bypass greeting cooldown", PermissionDefault.OP));
        this.registerCustomPermissions();
        this.logDebug("Permissions registered");
    }

    private void registerCustomPermissions() {
        FileConfiguration config = this.configManager.getConfig();
        if (!config.contains("customPermissions")) {
            return;
        }
        for (String permissionKey : config.getConfigurationSection("customPermissions").getKeys(false)) {
            try {
                if (this.getServer().getPluginManager().getPermission(permissionKey) != null) {
                    this.logDebug("Custom permission already exists, skipping: " + permissionKey);
                    continue;
                }
                this.getServer().getPluginManager().addPermission(new Permission(permissionKey, "Custom greeting permission: " + permissionKey, PermissionDefault.FALSE));
                this.logDebug("Registered custom permission: " + permissionKey);
            }
            catch (Exception e) {
                this.sendColoredMessage("<yellow>Failed to register custom permission: " + permissionKey + " - " + e.getMessage() + "</yellow>");
            }
        }
    }

    private void registerCommands() {
        boolean hasLifecycleAPI = false;
        try {
            Class.forName("io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType");
            hasLifecycleAPI = true;
        }
        catch (ClassNotFoundException e) {
            hasLifecycleAPI = false;
        }
        if (hasLifecycleAPI) {
            try {
                PaperCommandRegistrar paperCommandRegistrar = new PaperCommandRegistrar(this, this.commandHandler);
                paperCommandRegistrar.registerCommands();
                this.getServer().getConsoleSender().sendRichMessage("<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> <green>Commands registered using Paper Lifecycle API</green>");
            }
            catch (Exception e) {
                this.getServer().getConsoleSender().sendRichMessage("<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> <yellow>Paper Lifecycle API failed, falling back to Legacy command registration</yellow>");
                this.registerLegacyCommands();
            }
        } else {
            this.getServer().getConsoleSender().sendRichMessage("<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> <yellow>Paper Lifecycle API not available, using Legacy command registration</yellow>");
            this.registerLegacyCommands();
        }
    }

    private void registerLegacyCommands() {
        try {
            LegacyCommandRegistrar legacyCommandRegistrar = new LegacyCommandRegistrar(this, this.commandHandler);
            legacyCommandRegistrar.registerCommands();
            this.getServer().getConsoleSender().sendRichMessage("<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> <green>Commands registered using Legacy API</green>");
        }
        catch (Exception ex) {
            this.getServer().getConsoleSender().sendRichMessage("<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> <red>Failed to register commands with both APIs!</red>");
            this.getLogger().severe("Command registration failed: " + ex.getMessage());
        }
    }

    private void initializeMetrics() {
        try {
            int pluginId = 26490;
            Metrics metrics = new Metrics((Plugin)this, pluginId);
            this.logDebug("Metrics initialized");
        }
        catch (Exception e) {
            this.sendColoredMessage("<red>Failed to initialize metrics!</red>\n<#FF0000>" + String.valueOf(e));
        }
    }

    public void reload() {
        try {
            this.reloadConfig();
            this.configManager.loadConfig();
            this.debugMode = this.configManager.getConfig().getBoolean("settings.debug", false);
            this.registerCustomPermissions();
            this.bossBarManager.cleanup();
            this.logDebug("Plugin reloaded successfully");
            this.sendColoredMessage("ExtraGreetings configuration reloaded!");
        }
        catch (Exception e) {
            this.sendColoredMessage("<red>Failed to reload plugin!</red>\n<#FF0000>" + String.valueOf(e));
        }
    }

    public void logDebug(String message) {
        if (this.debugMode) {
            this.getServer().getConsoleSender().sendRichMessage("<gray>[<#FF00A8><bold>ExtraGreetings</bold></#FF00A8>]</gray> <#FFA500>" + message + "</#FFA500>");
        }
    }

    public void sendColoredMessage(String message) {
        this.getServer().getConsoleSender().sendRichMessage(PREFIX + message);
    }

    public String getPrefix() {
        return PREFIX;
    }

    public static ExtraGreetings getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public FirstJoinManager getFirstJoinManager() {
        return this.firstJoinManager;
    }

    public PlaceholderUtils getPlaceholderUtils() {
        return this.placeholderUtils;
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }
}

