/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.config;

import me.bloodred.extragreetings.ExtraGreetings;
import me.bloodred.extragreetings.config.ConfigUpdater;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ExtraGreetings plugin;
    private FileConfiguration config;
    private ConfigUpdater configUpdater;

    public ConfigManager(ExtraGreetings plugin) {
        this.plugin = plugin;
        this.configUpdater = new ConfigUpdater(plugin, "config.yml");
    }

    public void loadConfig() {
        boolean wasUpdated = this.configUpdater.update();
        if (wasUpdated) {
            this.plugin.sendColoredMessage("<green>Config has been updated to the latest version!</green>");
        }
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.validateConfig();
        this.plugin.logDebug("Configuration loaded successfully");
    }

    private void validateConfig() {
        if (!this.config.contains("settings")) {
            this.plugin.sendColoredMessage("<yellow>Missing 'settings' section in config.yml</yellow>");
        }
        if (!this.config.contains("join")) {
            this.plugin.sendColoredMessage("<yellow>Missing 'join' section in config.yml</yellow>");
        }
        if (!this.config.contains("quit")) {
            this.plugin.sendColoredMessage("<yellow>Missing 'quit' section in config.yml</yellow>");
        }
        this.validateSoundEffects();
        this.validateParticleEffects();
        this.validateCustomPermissions();
    }

    private void validateSoundEffects() {
        String[] soundPaths;
        for (String path : soundPaths = new String[]{"join.firstTime.sound.effect", "join.recurring.sound.effect", "join.vip.sound.effect", "quit.regular.sound.effect", "quit.vip.sound.effect"}) {
            String sound;
            if (!this.config.contains(path) || (sound = this.config.getString(path)) == null || sound.isEmpty()) continue;
            try {
                Sound.valueOf((String)sound.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.sendColoredMessage("<yellow>Invalid sound effect at " + path + ": " + sound + "</yellow>");
            }
        }
    }

    private void validateParticleEffects() {
        String[] particlePaths;
        for (String path : particlePaths = new String[]{"join.firstTime.particles.effect", "join.recurring.particles.effect", "join.vip.particles.effect", "quit.regular.particles.effect", "quit.vip.particles.effect"}) {
            String particle;
            if (!this.config.contains(path) || (particle = this.config.getString(path)) == null || particle.isEmpty()) continue;
            try {
                Particle.valueOf((String)particle.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.sendColoredMessage("<yellow>Invalid particle effect at " + path + ": " + particle + "</yellow>");
            }
        }
    }

    private void validateCustomPermissions() {
        if (!this.config.contains("customPermissions")) {
            return;
        }
        for (String permissionKey : this.config.getConfigurationSection("customPermissions").getKeys(false)) {
            String basePath = "customPermissions." + permissionKey;
            if (!this.config.contains(basePath + ".priority")) {
                this.plugin.sendColoredMessage("<yellow>Missing priority for custom permission: " + permissionKey + "</yellow>");
            }
            if (!this.config.contains(basePath + ".join")) {
                this.plugin.sendColoredMessage("<yellow>Missing join section for custom permission: " + permissionKey + "</yellow>");
            }
            if (!this.config.contains(basePath + ".quit")) {
                this.plugin.sendColoredMessage("<yellow>Missing quit section for custom permission: " + permissionKey + "</yellow>");
            }
            this.validateCustomPermissionEffects(permissionKey);
        }
    }

    private void validateCustomPermissionEffects(String permissionKey) {
        String[] soundPaths = new String[]{"customPermissions." + permissionKey + ".join.firstTime.sound.effect", "customPermissions." + permissionKey + ".join.recurring.sound.effect", "customPermissions." + permissionKey + ".quit.sound.effect"};
        String[] particlePaths = new String[]{"customPermissions." + permissionKey + ".join.firstTime.particles.effect", "customPermissions." + permissionKey + ".join.recurring.particles.effect", "customPermissions." + permissionKey + ".quit.particles.effect"};
        for (String path : soundPaths) {
            String sound;
            if (!this.config.contains(path) || (sound = this.config.getString(path)) == null || sound.isEmpty()) continue;
            try {
                Sound.valueOf((String)sound.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.sendColoredMessage("<yellow>Invalid sound effect at " + path + ": " + sound + "</yellow>");
            }
        }
        for (String path : particlePaths) {
            String particle;
            if (!this.config.contains(path) || (particle = this.config.getString(path)) == null || particle.isEmpty()) continue;
            try {
                Particle.valueOf((String)particle.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.sendColoredMessage("<yellow>Invalid particle effect at " + path + ": " + particle + "</yellow>");
            }
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }

    public boolean isJoinEnabled() {
        return this.config.getBoolean("settings.enableJoin", true);
    }

    public boolean isQuitEnabled() {
        return this.config.getBoolean("settings.enableQuit", true);
    }

    public int getCooldownSeconds() {
        return this.config.getInt("settings.cooldownSeconds", 60);
    }

    public boolean isDebugMode() {
        return this.config.getBoolean("settings.debug", false);
    }

    public int getJoinDelay() {
        return this.config.getInt("settings.joinDelay", 1);
    }

    public boolean isVipEnabled() {
        return this.config.contains("join.vip") || this.config.contains("quit.vip");
    }

    public ConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }
}

