/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.commands;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.bloodred.extragreetings.ExtraGreetings;
import me.bloodred.extragreetings.utils.GreetingUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraGreetingsCommand
implements CommandExecutor,
TabCompleter {
    private final ExtraGreetings plugin;
    private final MiniMessage miniMessage;
    private static final Component PLUGIN_NAME_FORMATTED = ((TextComponent)Component.text((String)"ExtraGreetings").color(TextColor.color((int)16711848))).decorate(TextDecoration.BOLD);
    private static final Component SEPARATOR = Component.text((String)"---------------------------------").color(TextColor.color((int)0xAAAAAA));

    public ExtraGreetingsCommand(ExtraGreetings plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("extragreetings.admin")) {
            this.sendErrorMessage(sender, "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender);
                break;
            }
            case "debug": {
                this.handleDebug(sender, args);
                break;
            }
            case "stats": {
                this.handleStats(sender);
                break;
            }
            case "reset": {
                this.handleReset(sender, args);
                break;
            }
            case "test": {
                this.handleTest(sender, args);
                break;
            }
            case "update": {
                this.handleUpdate(sender);
                break;
            }
            case "permissions": {
                this.handlePermissions(sender, args);
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void sendFormattedResponse(CommandSender sender, String title, List<Component> contentLines, NamedTextColor titleColor) {
        sender.sendMessage(SEPARATOR);
        Component commandPrefix = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)0xAAAAAA))).append(PLUGIN_NAME_FORMATTED)).append(Component.text((String)"] ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)("(v" + this.plugin.getDescription().getVersion() + ")")).color(TextColor.color((int)0xAAAAAA)));
        sender.sendMessage(commandPrefix);
        sender.sendMessage(SEPARATOR);
        if (title != null && !title.isEmpty()) {
            Component titleComponent = ((TextComponent)Component.text((String)title).color((TextColor)titleColor)).decorate(TextDecoration.BOLD);
            sender.sendMessage(titleComponent);
            sender.sendMessage(SEPARATOR);
        }
        for (Component line : contentLines) {
            sender.sendMessage(line);
        }
        sender.sendMessage(SEPARATOR);
    }

    private void sendHelpMessage(CommandSender sender) {
        List<Component> helpLines = Arrays.asList(((TextComponent)((TextComponent)Component.text((String)"/extragreetings reload").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Reload the configuration").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings info").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Show plugin information").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings stats").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Show plugin statistics").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings debug [on/off]").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Toggle debug mode").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings reset [data/cooldowns]").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Reset plugin data").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings test [join/quit]").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Test greetings (players only)").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings update").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Update configuration to latest version").color((TextColor)NamedTextColor.GRAY)), ((TextComponent)((TextComponent)Component.text((String)"/extragreetings permissions [player]").color((TextColor)NamedTextColor.DARK_GREEN)).append(Component.text((String)" - ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)"Show custom permissions for player").color((TextColor)NamedTextColor.GRAY)));
        this.sendFormattedResponse(sender, "Command Help", helpLines, NamedTextColor.DARK_PURPLE);
    }

    private void handleReload(CommandSender sender) {
        try {
            this.plugin.reload();
            List<Component> lines = Arrays.asList(Component.text((String)"ExtraGreetings configuration reloaded successfully!").color((TextColor)NamedTextColor.GREEN));
            this.sendFormattedResponse(sender, "Reload", lines, NamedTextColor.GREEN);
        }
        catch (Exception e) {
            this.sendErrorMessage(sender, "Failed to reload configuration: " + e.getMessage());
        }
    }

    private void handleInfo(CommandSender sender) {
        List<Component> infoLines = Arrays.asList(((TextComponent)Component.text((String)"Author: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)"Bloodred").color((TextColor)NamedTextColor.WHITE)), ((TextComponent)Component.text((String)"Join greetings: ").color((TextColor)NamedTextColor.AQUA)).append(this.formatStatusText(this.plugin.getConfigManager().isJoinEnabled())), ((TextComponent)Component.text((String)"Quit greetings: ").color((TextColor)NamedTextColor.AQUA)).append(this.formatStatusText(this.plugin.getConfigManager().isQuitEnabled())), ((TextComponent)Component.text((String)"PlaceholderAPI: ").color((TextColor)NamedTextColor.AQUA)).append(this.formatStatusText(this.plugin.isPlaceholderAPIEnabled())), ((TextComponent)Component.text((String)"Debug mode: ").color((TextColor)NamedTextColor.AQUA)).append(this.formatStatusText(this.plugin.isDebugMode())), ((TextComponent)Component.text((String)"Cooldown: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)(this.plugin.getConfigManager().getCooldownSeconds() + " seconds")).color((TextColor)NamedTextColor.WHITE)));
        this.sendFormattedResponse(sender, "Plugin Information", infoLines, NamedTextColor.BLUE);
    }

    private void handleStats(CommandSender sender) {
        int joinedPlayers = this.plugin.getFirstJoinManager().getJoinedPlayerCount();
        int activeCooldowns = this.plugin.getCooldownManager().getActiveCooldownCount();
        int activeBossBars = this.plugin.getBossBarManager().getActiveBossBarCount();
        List<Component> statsLines = Arrays.asList(((TextComponent)Component.text((String)"Players who have joined: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)joinedPlayers).color((TextColor)NamedTextColor.WHITE)), ((TextComponent)Component.text((String)"Active cooldowns: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)activeCooldowns).color((TextColor)NamedTextColor.WHITE)), ((TextComponent)Component.text((String)"Active boss bars: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((int)activeBossBars).color((TextColor)NamedTextColor.WHITE)));
        this.sendFormattedResponse(sender, "Statistics", statsLines, NamedTextColor.DARK_GREEN);
    }

    private void handleDebug(CommandSender sender, String[] args) {
        if (args.length < 2) {
            List<Component> lines = Arrays.asList(((TextComponent)Component.text((String)"Debug mode is currently: ").color((TextColor)NamedTextColor.AQUA)).append(this.formatStatusText(this.plugin.isDebugMode())));
            this.sendFormattedResponse(sender, "Debug Status", lines, NamedTextColor.YELLOW);
            return;
        }
        String action = args[1].toLowerCase();
        if (action.equals("on") || action.equals("true")) {
            this.plugin.getConfigManager().getConfig().set("settings.debug", (Object)true);
            this.plugin.getConfigManager().saveConfig();
            this.sendSuccessMessage(sender, "Debug mode enabled!");
        } else if (action.equals("off") || action.equals("false")) {
            this.plugin.getConfigManager().getConfig().set("settings.debug", (Object)false);
            this.plugin.getConfigManager().saveConfig();
            this.sendSuccessMessage(sender, "Debug mode disabled!");
        } else {
            this.sendErrorMessage(sender, "Usage: /extragreetings debug [on/off]");
        }
    }

    private void handleReset(CommandSender sender, String[] args) {
        String resetType;
        if (args.length < 2) {
            this.sendErrorMessage(sender, "Usage: /extragreetings reset [data/cooldowns]");
            return;
        }
        switch (resetType = args[1].toLowerCase()) {
            case "data": {
                this.plugin.getFirstJoinManager().clearAllData();
                this.sendSuccessMessage(sender, "All player data has been reset!");
                break;
            }
            case "cooldowns": {
                this.plugin.getCooldownManager().clearAllCooldowns();
                this.sendSuccessMessage(sender, "All cooldowns have been cleared!");
                break;
            }
            default: {
                this.sendErrorMessage(sender, "Usage: /extragreetings reset [data/cooldowns]");
            }
        }
    }

    private void handleTest(CommandSender sender, String[] args) {
        String testType;
        if (!(sender instanceof Player)) {
            this.sendErrorMessage(sender, "This command can only be used by players!");
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.sendErrorMessage(sender, "Usage: /extragreetings test [join/quit]");
            return;
        }
        switch (testType = args[1].toLowerCase()) {
            case "join": {
                Object configPath;
                this.plugin.logDebug("Testing join greeting for " + player.getName());
                this.sendInfoMessage(sender, "Testing join greeting...");
                boolean isFirstTime = !this.plugin.getFirstJoinManager().hasJoinedBefore(player.getUniqueId());
                boolean isVip = player.hasPermission("extragreetings.vip") && this.plugin.getConfigManager().isVipEnabled();
                String customPermission = this.getHighestPriorityCustomPermission(player);
                if (customPermission != null) {
                    String baseConfigPath = "customPermissions." + customPermission + ".join";
                    if (isFirstTime) {
                        configPath = baseConfigPath + ".firstTime";
                        this.sendInfoMessage(sender, "Triggering custom permission (" + customPermission + ") first-time join greeting...");
                    } else {
                        configPath = baseConfigPath + ".recurring";
                        this.sendInfoMessage(sender, "Triggering custom permission (" + customPermission + ") recurring join greeting...");
                    }
                } else if (isVip) {
                    configPath = "join.vip";
                    this.sendInfoMessage(sender, "Triggering VIP join greeting...");
                } else if (isFirstTime) {
                    configPath = "join.firstTime";
                    this.sendInfoMessage(sender, "Triggering first-time join greeting...");
                } else {
                    configPath = "join.recurring";
                    this.sendInfoMessage(sender, "Triggering recurring join greeting...");
                }
                this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, arg_0 -> this.lambda$handleTest$0(player, (String)configPath, arg_0), 20L);
                break;
            }
            case "quit": {
                Object quitConfigPath;
                this.plugin.logDebug("Testing quit greeting for " + player.getName());
                this.sendInfoMessage(sender, "Testing quit greeting...");
                boolean isVipQuit = player.hasPermission("extragreetings.vip") && this.plugin.getConfigManager().isVipEnabled();
                String customPermissionQuit = this.getHighestPriorityCustomPermission(player);
                if (customPermissionQuit != null) {
                    quitConfigPath = "customPermissions." + customPermissionQuit + ".quit";
                    this.sendInfoMessage(sender, "Triggering custom permission (" + customPermissionQuit + ") quit greeting...");
                } else if (isVipQuit) {
                    quitConfigPath = "quit.vip";
                    this.sendInfoMessage(sender, "Triggering VIP quit greeting...");
                } else {
                    quitConfigPath = "quit.regular";
                    this.sendInfoMessage(sender, "Triggering regular quit greeting...");
                }
                this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, arg_0 -> this.lambda$handleTest$1(player, (String)quitConfigPath, arg_0), 20L);
                break;
            }
            default: {
                this.sendErrorMessage(sender, "Usage: /extragreetings test [join/quit]");
            }
        }
    }

    private void handleUpdate(CommandSender sender) {
        try {
            this.sendInfoMessage(sender, "Updating configuration...");
            boolean wasUpdated = this.plugin.getConfigManager().getConfigUpdater().update();
            if (wasUpdated) {
                this.sendSuccessMessage(sender, "Configuration updated successfully!");
            } else {
                this.sendInfoMessage(sender, "Configuration is already up to date.");
            }
        }
        catch (Exception e) {
            this.sendErrorMessage(sender, "Failed to update config: " + e.getMessage());
            this.plugin.logDebug("Config update error: " + e.getMessage());
        }
    }

    private void handlePermissions(CommandSender sender, String[] args) {
        Player targetPlayer = null;
        if (args.length > 1) {
            targetPlayer = this.plugin.getServer().getPlayer(args[1]);
            if (targetPlayer == null) {
                this.sendErrorMessage(sender, "Player '" + args[1] + "' not found or not online!");
                return;
            }
        } else if (sender instanceof Player) {
            targetPlayer = (Player)sender;
        } else {
            this.sendErrorMessage(sender, "Usage: /extragreetings permissions <player>");
            return;
        }
        ArrayList<Component> permissionLines = new ArrayList<Component>();
        if (!this.plugin.getConfigManager().getConfig().contains("customPermissions")) {
            permissionLines.add(Component.text((String)"No custom permissions configured.").color((TextColor)NamedTextColor.GRAY));
        } else {
            String highestPermission = this.getHighestPriorityCustomPermission(targetPlayer);
            if (highestPermission != null) {
                int priority = this.plugin.getConfigManager().getConfig().getInt("customPermissions." + highestPermission + ".priority", 0);
                permissionLines.add(((TextComponent)((TextComponent)Component.text((String)"Active permission: ").color((TextColor)NamedTextColor.AQUA)).append(Component.text((String)highestPermission).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)(" (priority: " + priority + ")")).color((TextColor)NamedTextColor.GRAY)));
            } else {
                permissionLines.add(Component.text((String)"No custom permissions found for this player.").color((TextColor)NamedTextColor.GRAY));
            }
            permissionLines.add(Component.text((String)"").color((TextColor)NamedTextColor.WHITE));
            permissionLines.add(Component.text((String)"All custom permissions:").color((TextColor)NamedTextColor.YELLOW));
            for (String permissionKey : this.plugin.getConfigManager().getConfig().getConfigurationSection("customPermissions").getKeys(false)) {
                boolean hasPermission = targetPlayer.hasPermission(permissionKey);
                int priority = this.plugin.getConfigManager().getConfig().getInt("customPermissions." + permissionKey + ".priority", 0);
                Component permissionLine = ((TextComponent)Component.text((String)("\u2022 " + permissionKey)).color((TextColor)(hasPermission ? NamedTextColor.GREEN : NamedTextColor.RED))).append(Component.text((String)(" (priority: " + priority + ")")).color((TextColor)NamedTextColor.GRAY));
                permissionLine = hasPermission ? permissionLine.append(Component.text((String)" \u2713").color((TextColor)NamedTextColor.GREEN)) : permissionLine.append(Component.text((String)" \u2717").color((TextColor)NamedTextColor.RED));
                permissionLines.add(permissionLine);
            }
        }
        this.sendFormattedResponse(sender, "Custom Permissions for " + targetPlayer.getName(), permissionLines, NamedTextColor.BLUE);
    }

    private String getHighestPriorityCustomPermission(Player player) {
        if (!this.plugin.getConfigManager().getConfig().contains("customPermissions")) {
            return null;
        }
        String highestPermission = null;
        int highestPriority = -1;
        for (String permissionKey : this.plugin.getConfigManager().getConfig().getConfigurationSection("customPermissions").getKeys(false)) {
            int priority;
            if (!player.hasPermission(permissionKey) || (priority = this.plugin.getConfigManager().getConfig().getInt("customPermissions." + permissionKey + ".priority", 0)) <= highestPriority) continue;
            highestPriority = priority;
            highestPermission = permissionKey;
        }
        return highestPermission;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (!sender.hasPermission("extragreetings.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "info", "stats", "debug", "reset", "test", "update", "permissions");
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "debug": {
                    return Arrays.asList("on", "off");
                }
                case "reset": {
                    return Arrays.asList("data", "cooldowns");
                }
                case "test": {
                    return Arrays.asList("join", "quit");
                }
                case "update": {
                    return Arrays.asList(new String[0]);
                }
                case "permissions": {
                    ArrayList<String> playerNames = new ArrayList<String>();
                    for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                        playerNames.add(player.getName());
                    }
                    return playerNames;
                }
            }
        }
        return new ArrayList<String>();
    }

    private void sendSuccessMessage(CommandSender sender, String message) {
        Component msg = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)0xAAAAAA))).append(PLUGIN_NAME_FORMATTED)).append(Component.text((String)"] ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)message).color((TextColor)NamedTextColor.GREEN));
        sender.sendMessage(msg);
    }

    private void sendErrorMessage(CommandSender sender, String message) {
        Component msg = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)0xAAAAAA))).append(PLUGIN_NAME_FORMATTED)).append(Component.text((String)"] ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)message).color((TextColor)NamedTextColor.RED));
        sender.sendMessage(msg);
    }

    private void sendInfoMessage(CommandSender sender, String message) {
        Component msg = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color(TextColor.color((int)0xAAAAAA))).append(PLUGIN_NAME_FORMATTED)).append(Component.text((String)"] ").color(TextColor.color((int)0xAAAAAA)))).append(Component.text((String)message).color((TextColor)NamedTextColor.YELLOW));
        sender.sendMessage(msg);
    }

    private Component formatStatusText(boolean enabled) {
        return Component.text((String)(enabled ? "Enabled" : "Disabled")).color((TextColor)(enabled ? NamedTextColor.GREEN : NamedTextColor.RED));
    }

    private /* synthetic */ void lambda$handleTest$1(Player player, String quitConfigPath, ScheduledTask task) {
        try {
            GreetingUtils greetingUtils = new GreetingUtils(this.plugin);
            greetingUtils.spawnParticles(player, quitConfigPath);
            greetingUtils.playSound(player, quitConfigPath);
            greetingUtils.sendChatMessage(player, quitConfigPath);
            greetingUtils.executeCommands(player, quitConfigPath);
            this.plugin.logDebug("Test quit greeting executed successfully for " + player.getName());
        }
        catch (Exception e) {
            this.plugin.sendColoredMessage("<red>Error executing test quit greeting: " + e.getMessage() + "</red>");
        }
    }

    private /* synthetic */ void lambda$handleTest$0(Player player, String configPath, ScheduledTask task) {
        try {
            GreetingUtils greetingUtils = new GreetingUtils(this.plugin);
            greetingUtils.sendTitle(player, configPath);
            greetingUtils.sendActionBar(player, configPath);
            greetingUtils.createBossBar(player, configPath);
            greetingUtils.spawnParticles(player, configPath);
            greetingUtils.playSound(player, configPath);
            greetingUtils.sendChatMessage(player, configPath);
            greetingUtils.executeCommands(player, configPath);
            this.plugin.logDebug("Test join greeting executed successfully for " + player.getName());
        }
        catch (Exception e) {
            this.plugin.sendColoredMessage("<red>Error executing test join greeting: " + e.getMessage() + "</red>");
        }
    }
}

