/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.listeners;

import java.util.UUID;
import me.bloodred.extragreetings.ExtraGreetings;
import me.bloodred.extragreetings.utils.GreetingUtils;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerEventListener
implements Listener {
    private final ExtraGreetings plugin;
    private final MiniMessage miniMessage;
    private final GreetingUtils greetingUtils;

    public PlayerEventListener(ExtraGreetings plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.greetingUtils = new GreetingUtils(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.plugin.logDebug("Player " + player.getName() + " joined the server");
        if (!this.plugin.getConfigManager().isJoinEnabled()) {
            return;
        }
        if (this.plugin.getCooldownManager().isOnCooldown(playerUUID)) {
            this.plugin.logDebug("Player " + player.getName() + " is on cooldown, skipping greeting");
            return;
        }
        if (!player.hasPermission("extragreetings.bypass.cooldown")) {
            this.plugin.getCooldownManager().setCooldown(playerUUID, this.plugin.getConfigManager().getCooldownSeconds());
        }
        event.setJoinMessage(null);
        int delay = this.plugin.getConfigManager().getJoinDelay();
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> this.handleJoinGreeting(player), (long)delay * 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.plugin.logDebug("Player " + player.getName() + " left the server");
        if (!this.plugin.getConfigManager().isQuitEnabled()) {
            return;
        }
        event.setQuitMessage(null);
        this.handleQuitGreeting(player);
        this.plugin.getBossBarManager().removeBossBar(playerUUID);
    }

    private void handleJoinGreeting(Player player) {
        Object configPath;
        String customPermission;
        boolean isFirstTime = !this.plugin.getFirstJoinManager().hasJoinedBefore(player.getUniqueId());
        boolean isVip = player.hasPermission("extragreetings.vip") && this.plugin.getConfigManager().isVipEnabled();
        this.plugin.logDebug("Handling join greeting for " + player.getName() + " (First time: " + isFirstTime + ", VIP: " + isVip + ")");
        if (isFirstTime) {
            this.plugin.getFirstJoinManager().markAsJoined(player.getUniqueId());
        }
        if ((customPermission = this.getHighestPriorityCustomPermission(player)) != null) {
            String baseConfigPath = "customPermissions." + customPermission + ".join";
            configPath = isFirstTime ? baseConfigPath + ".firstTime" : baseConfigPath + ".recurring";
            this.plugin.logDebug("Using custom permission greeting: " + customPermission + " for " + player.getName());
        } else {
            configPath = isVip ? "join.vip" : (isFirstTime ? "join.firstTime" : "join.recurring");
        }
        this.executeJoinGreeting(player, (String)configPath);
    }

    private void executeJoinGreeting(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        this.greetingUtils.sendTitle(player, configPath);
        this.greetingUtils.sendActionBar(player, configPath);
        this.greetingUtils.createBossBar(player, configPath);
        this.greetingUtils.spawnParticles(player, configPath);
        this.greetingUtils.playSound(player, configPath);
        this.greetingUtils.sendChatMessage(player, configPath);
        this.greetingUtils.executeCommands(player, configPath);
    }

    private void handleQuitGreeting(Player player) {
        Object configPath;
        this.plugin.logDebug("Handling quit greeting for " + player.getName());
        String customPermission = this.getHighestPriorityCustomPermission(player);
        if (customPermission != null) {
            configPath = "customPermissions." + customPermission + ".quit";
            this.plugin.logDebug("Using custom permission quit greeting: " + customPermission + " for " + player.getName());
        } else if (player.hasPermission("extragreetings.vip") && this.plugin.getConfigManager().isVipEnabled()) {
            configPath = "quit.vip";
            this.plugin.logDebug("Using VIP quit greeting for " + player.getName());
        } else {
            configPath = "quit.regular";
            this.plugin.logDebug("Using regular quit greeting for " + player.getName());
        }
        this.greetingUtils.spawnParticles(player, (String)configPath);
        this.greetingUtils.playSound(player, (String)configPath);
        this.greetingUtils.sendChatMessage(player, (String)configPath);
        this.greetingUtils.executeCommands(player, (String)configPath);
    }

    private String getHighestPriorityCustomPermission(Player player) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        if (!config.contains("customPermissions")) {
            return null;
        }
        String highestPermission = null;
        int highestPriority = -1;
        for (String permissionKey : config.getConfigurationSection("customPermissions").getKeys(false)) {
            if (!player.hasPermission(permissionKey)) continue;
            int priority = config.getInt("customPermissions." + permissionKey + ".priority", 0);
            if (priority > highestPriority) {
                highestPriority = priority;
                highestPermission = permissionKey;
            }
            this.plugin.logDebug("Player " + player.getName() + " has permission " + permissionKey + " with priority " + priority);
        }
        if (highestPermission != null) {
            this.plugin.logDebug("Highest priority permission for " + player.getName() + ": " + highestPermission + " (priority: " + highestPriority + ")");
        }
        return highestPermission;
    }
}

