/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BossBarManager {
    private final Map<UUID, BossBar> activeBossBars = new HashMap<UUID, BossBar>();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public void createBossBar(Player player, String text, BossBar.Color color, BossBar.Overlay overlay, int duration, JavaPlugin plugin) {
        UUID playerUUID = player.getUniqueId();
        this.removeBossBar(playerUUID);
        Component component = this.miniMessage.deserialize((Object)text);
        BossBar bossBar = BossBar.bossBar((Component)component, (float)1.0f, (BossBar.Color)color, (BossBar.Overlay)overlay);
        player.showBossBar(bossBar);
        this.activeBossBars.put(playerUUID, bossBar);
        if (duration > 0) {
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)plugin, task -> this.removeBossBar(playerUUID), (long)duration * 20L);
        }
    }

    public void removeBossBar(UUID playerUUID) {
        Player player;
        BossBar bossBar = this.activeBossBars.remove(playerUUID);
        if (bossBar != null && (player = Bukkit.getPlayer((UUID)playerUUID)) != null && player.isOnline()) {
            player.hideBossBar(bossBar);
        }
    }

    public void updateBossBar(UUID playerUUID, String newText) {
        BossBar bossBar = this.activeBossBars.get(playerUUID);
        if (bossBar != null) {
            Component component = this.miniMessage.deserialize((Object)newText);
            bossBar.name(component);
        }
    }

    public void updateBossBarProgress(UUID playerUUID, float progress) {
        BossBar bossBar = this.activeBossBars.get(playerUUID);
        if (bossBar != null) {
            bossBar.progress(Math.max(0.0f, Math.min(1.0f, progress)));
        }
    }

    public boolean hasBossBar(UUID playerUUID) {
        return this.activeBossBars.containsKey(playerUUID);
    }

    public void cleanup() {
        for (Map.Entry<UUID, BossBar> entry : this.activeBossBars.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) continue;
            player.hideBossBar(entry.getValue());
        }
        this.activeBossBars.clear();
    }

    public static BossBar.Color parseColor(String colorString) {
        try {
            return BossBar.Color.valueOf((String)colorString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BossBar.Color.WHITE;
        }
    }

    public static BossBar.Overlay parseOverlay(String overlayString) {
        try {
            return BossBar.Overlay.valueOf((String)overlayString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BossBar.Overlay.PROGRESS;
        }
    }

    public int getActiveBossBarCount() {
        return this.activeBossBars.size();
    }
}

