/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public void setCooldown(UUID playerUUID, long cooldownMillis) {
        this.cooldowns.put(playerUUID, System.currentTimeMillis() + cooldownMillis);
    }

    public void setCooldown(UUID playerUUID, int cooldownSeconds) {
        this.setCooldown(playerUUID, (long)cooldownSeconds * 1000L);
    }

    public boolean isOnCooldown(UUID playerUUID) {
        Long cooldownTime = this.cooldowns.get(playerUUID);
        if (cooldownTime == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= cooldownTime) {
            this.cooldowns.remove(playerUUID);
            return false;
        }
        return true;
    }

    public long getRemainingCooldown(UUID playerUUID) {
        Long cooldownTime = this.cooldowns.get(playerUUID);
        if (cooldownTime == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= cooldownTime) {
            this.cooldowns.remove(playerUUID);
            return 0L;
        }
        return cooldownTime - currentTime;
    }

    public void removeCooldown(UUID playerUUID) {
        this.cooldowns.remove(playerUUID);
    }

    public void clearAllCooldowns() {
        this.cooldowns.clear();
    }

    public int getActiveCooldownCount() {
        long currentTime = System.currentTimeMillis();
        this.cooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        return this.cooldowns.size();
    }
}

