/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.bloodred.extragreetings.ExtraGreetings;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FirstJoinManager {
    private final ExtraGreetings plugin;
    private final File dataFile;
    private FileConfiguration dataConfig;
    private final Set<UUID> joinedPlayers = new HashSet<UUID>();

    public FirstJoinManager(ExtraGreetings plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "playerdata.yml");
        this.loadData();
    }

    private void loadData() {
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create playerdata.yml file!");
                return;
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (this.dataConfig.contains("joined-players")) {
            List uuidStrings = this.dataConfig.getStringList("joined-players");
            for (String uuidString : uuidStrings) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    this.joinedPlayers.add(uuid);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in playerdata.yml: " + uuidString);
                }
            }
        }
        this.plugin.logDebug("Loaded " + this.joinedPlayers.size() + " player records from playerdata.yml");
    }

    public void saveData() {
        if (this.dataConfig == null) {
            return;
        }
        try {
            List<String> uuidStrings = this.joinedPlayers.stream().map(UUID::toString).toList();
            this.dataConfig.set("joined-players", uuidStrings);
            this.dataConfig.save(this.dataFile);
            this.plugin.logDebug("Saved " + this.joinedPlayers.size() + " player records to playerdata.yml");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save playerdata.yml file!");
        }
    }

    public boolean hasJoinedBefore(UUID playerUUID) {
        return this.joinedPlayers.contains(playerUUID);
    }

    public void markAsJoined(UUID playerUUID) {
        if (this.joinedPlayers.add(playerUUID)) {
            this.plugin.logDebug("Marked player " + String.valueOf(playerUUID) + " as having joined before");
            this.saveData();
        }
    }

    public void removePlayer(UUID playerUUID) {
        if (this.joinedPlayers.remove(playerUUID)) {
            this.plugin.logDebug("Removed player " + String.valueOf(playerUUID) + " from joined players list");
            this.saveData();
        }
    }

    public void clearAllData() {
        this.joinedPlayers.clear();
        this.saveData();
        this.plugin.logDebug("Cleared all player data");
    }

    public int getJoinedPlayerCount() {
        return this.joinedPlayers.size();
    }

    public Set<UUID> getJoinedPlayers() {
        return new HashSet<UUID>(this.joinedPlayers);
    }
}

