/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.utils;

import java.time.Duration;
import java.util.List;
import me.bloodred.extragreetings.ExtraGreetings;
import me.bloodred.extragreetings.managers.BossBarManager;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GreetingUtils {
    private final ExtraGreetings plugin;
    private final MiniMessage miniMessage;

    public GreetingUtils(ExtraGreetings plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
    }

    public void sendTitle(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String titleText = config.getString(configPath + ".title");
        String subtitleText = config.getString(configPath + ".subtitle");
        if (titleText == null && subtitleText == null) {
            return;
        }
        if (titleText != null) {
            titleText = this.plugin.getPlaceholderUtils().replacePlaceholders(player, titleText);
        }
        if (subtitleText != null) {
            subtitleText = this.plugin.getPlaceholderUtils().replacePlaceholders(player, subtitleText);
        }
        TextComponent titleComponent = titleText != null ? this.miniMessage.deserialize((Object)titleText) : Component.empty();
        TextComponent subtitleComponent = subtitleText != null ? this.miniMessage.deserialize((Object)subtitleText) : Component.empty();
        Title title = Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(500L)));
        player.showTitle(title);
        this.plugin.logDebug("Sent title to " + player.getName() + ": " + titleText + " / " + subtitleText);
    }

    public void sendActionBar(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String actionBarText = config.getString(configPath + ".actionbar");
        if (actionBarText == null || actionBarText.isEmpty()) {
            return;
        }
        actionBarText = this.plugin.getPlaceholderUtils().replacePlaceholders(player, actionBarText);
        Component actionBarComponent = this.miniMessage.deserialize((Object)actionBarText);
        player.sendActionBar(actionBarComponent);
        this.plugin.logDebug("Sent action bar to " + player.getName() + ": " + actionBarText);
    }

    public void createBossBar(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        if (!config.getBoolean(configPath + ".bossbar.enable", false)) {
            return;
        }
        String bossBarText = config.getString(configPath + ".bossbar.text");
        if (bossBarText == null || bossBarText.isEmpty()) {
            return;
        }
        bossBarText = this.plugin.getPlaceholderUtils().replacePlaceholders(player, bossBarText);
        String colorString = config.getString(configPath + ".bossbar.color", "WHITE");
        String styleString = config.getString(configPath + ".bossbar.style", "SOLID");
        int duration = config.getInt(configPath + ".bossbar.duration", 10);
        BossBar.Color color = BossBarManager.parseColor(colorString);
        BossBar.Overlay overlay = BossBarManager.parseOverlay(styleString);
        this.plugin.getBossBarManager().createBossBar(player, bossBarText, color, overlay, duration, this.plugin);
        this.plugin.logDebug("Created boss bar for " + player.getName() + ": " + bossBarText);
    }

    public void spawnParticles(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        if (!config.getBoolean(configPath + ".particles.enable", false)) {
            return;
        }
        String particleEffect = config.getString(configPath + ".particles.effect");
        if (particleEffect == null || particleEffect.isEmpty()) {
            return;
        }
        try {
            Particle particle = Particle.valueOf((String)particleEffect.toUpperCase());
            int count = config.getInt(configPath + ".particles.count", 10);
            double offsetX = config.getDouble(configPath + ".particles.offset.x", 0.5);
            double offsetY = config.getDouble(configPath + ".particles.offset.y", 0.5);
            double offsetZ = config.getDouble(configPath + ".particles.offset.z", 0.5);
            double speed = config.getDouble(configPath + ".particles.speed", 0.1);
            Location location = player.getLocation().add(0.0, 1.0, 0.0);
            player.getWorld().spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, speed);
            this.plugin.logDebug("Spawned particles for " + player.getName() + ": " + particleEffect + " x" + count);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid particle effect: " + particleEffect);
        }
        catch (IncompatibleClassChangeError e) {
            this.plugin.getLogger().warning("Particle system compatibility issue with effect: " + particleEffect + " - " + e.getMessage());
            this.plugin.logDebug("IncompatibleClassChangeError during particle spawn: " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Unexpected error spawning particle effect: " + particleEffect + " - " + e.getMessage());
            this.plugin.logDebug("Unexpected particle spawn error: " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public void playSound(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        if (!config.getBoolean(configPath + ".sound.enable", false)) {
            return;
        }
        String soundEffect = config.getString(configPath + ".sound.effect");
        if (soundEffect == null || soundEffect.isEmpty()) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundEffect.toUpperCase());
            float volume = (float)config.getDouble(configPath + ".sound.volume", 1.0);
            float pitch = (float)config.getDouble(configPath + ".sound.pitch", 1.0);
            player.playSound(player.getLocation(), sound, volume, pitch);
            this.plugin.logDebug("Played sound for " + player.getName() + ": " + soundEffect + " (vol: " + volume + ", pitch: " + pitch + ")");
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound effect: " + soundEffect);
        }
        catch (IncompatibleClassChangeError e) {
            this.plugin.getLogger().warning("Sound system compatibility issue with effect: " + soundEffect + " - " + e.getMessage());
            this.plugin.logDebug("IncompatibleClassChangeError during sound playback: " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Unexpected error playing sound effect: " + soundEffect + " - " + e.getMessage());
            this.plugin.logDebug("Unexpected sound playback error: " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public void sendChatMessage(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String message = config.getString(configPath + ".message");
        if (message == null || message.isEmpty()) {
            return;
        }
        message = this.plugin.getPlaceholderUtils().replacePlaceholders(player, message);
        Component messageComponent = this.miniMessage.deserialize((Object)message);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.sendMessage(messageComponent);
        }
        Bukkit.getConsoleSender().sendMessage(messageComponent);
        this.plugin.logDebug("Sent chat message: " + message);
    }

    public void executeCommands(Player player, String configPath) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        if (!config.contains(configPath + ".commands")) {
            return;
        }
        List commands = config.getStringList(configPath + ".commands");
        if (commands.isEmpty()) {
            return;
        }
        for (String command : commands) {
            if (command == null || command.isEmpty()) continue;
            String finalCommand = this.plugin.getPlaceholderUtils().replacePlaceholders(player, command);
            Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> {
                try {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
                    this.plugin.logDebug("Executed command: " + finalCommand);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to execute command: " + finalCommand + " - " + e.getMessage());
                }
            });
        }
    }

    public void sendCustomEffect(Player player, String configPath, String effectName) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        if (!config.contains(configPath + ".effects." + effectName)) {
            return;
        }
        String effectType = config.getString(configPath + ".effects." + effectName + ".type");
        if (effectType == null) {
            return;
        }
        switch (effectType.toLowerCase()) {
            case "spiral": {
                this.createSpiralParticles(player, configPath, effectName);
                break;
            }
            case "circle": {
                this.createCircleParticles(player, configPath, effectName);
                break;
            }
            case "explosion": {
                this.createExplosionEffect(player, configPath, effectName);
                break;
            }
            default: {
                this.plugin.getLogger().warning("Unknown effect type: " + effectType);
            }
        }
    }

    private void createSpiralParticles(Player player, String configPath, String effectName) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String basePath = configPath + ".effects." + effectName;
        String particleEffect = config.getString(basePath + ".particle", "FLAME");
        int duration = config.getInt(basePath + ".duration", 5);
        double radius = config.getDouble(basePath + ".radius", 2.0);
        try {
            Particle particle = Particle.valueOf((String)particleEffect.toUpperCase());
            Location center = player.getLocation();
            Particle finalParticle = particle;
            Location finalCenter = center;
            double finalRadius = radius;
            Player finalPlayer = player;
            for (int i = 0; i < duration * 20; ++i) {
                int tick = i;
                Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> {
                    double angle = (double)tick * 0.2;
                    double y = (double)tick * 0.1;
                    double x = Math.cos(angle) * finalRadius;
                    double z = Math.sin(angle) * finalRadius;
                    Location particleLocation = finalCenter.clone().add(x, y, z);
                    finalPlayer.getWorld().spawnParticle(finalParticle, particleLocation, 1);
                }, (long)i);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid particle effect for spiral: " + particleEffect);
        }
    }

    private void createCircleParticles(Player player, String configPath, String effectName) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String basePath = configPath + ".effects." + effectName;
        String particleEffect = config.getString(basePath + ".particle", "FLAME");
        double radius = config.getDouble(basePath + ".radius", 2.0);
        int points = config.getInt(basePath + ".points", 20);
        try {
            Particle particle = Particle.valueOf((String)particleEffect.toUpperCase());
            Location center = player.getLocation();
            for (int i = 0; i < points; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)points;
                double x = Math.cos(angle) * radius;
                double z = Math.sin(angle) * radius;
                Location particleLocation = center.clone().add(x, 1.0, z);
                player.getWorld().spawnParticle(particle, particleLocation, 1);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid particle effect for circle: " + particleEffect);
        }
    }

    private void createExplosionEffect(Player player, String configPath, String effectName) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String basePath = configPath + ".effects." + effectName;
        String particleEffect = config.getString(basePath + ".particle", "EXPLOSION_LARGE");
        int count = config.getInt(basePath + ".count", 5);
        double spread = config.getDouble(basePath + ".spread", 2.0);
        try {
            Particle particle = Particle.valueOf((String)particleEffect.toUpperCase());
            Location center = player.getLocation().add(0.0, 1.0, 0.0);
            for (int i = 0; i < count; ++i) {
                double x = (Math.random() - 0.5) * spread;
                double y = (Math.random() - 0.5) * spread;
                double z = (Math.random() - 0.5) * spread;
                Location particleLocation = center.clone().add(x, y, z);
                player.getWorld().spawnParticle(particle, particleLocation, 1);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid particle effect for explosion: " + particleEffect);
        }
    }
}

