/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.extragreetings.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import me.bloodred.extragreetings.ExtraGreetings;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlaceholderUtils {
    private final ExtraGreetings plugin;
    private final Map<String, String> customPlaceholders;

    public PlaceholderUtils(ExtraGreetings plugin) {
        this.plugin = plugin;
        this.customPlaceholders = new HashMap<String, String>();
    }

    public void initialize() {
        this.loadCustomPlaceholders();
    }

    private void loadCustomPlaceholders() {
        if (this.plugin.getConfigManager().getConfig() == null) {
            this.plugin.logDebug("Config not available, skipping custom placeholder loading");
            return;
        }
        if (this.plugin.getConfigManager().getConfig().contains("placeholders")) {
            for (String key : this.plugin.getConfigManager().getConfig().getConfigurationSection("placeholders").getKeys(false)) {
                String value = this.plugin.getConfigManager().getConfig().getString("placeholders." + key);
                if (value == null) continue;
                this.customPlaceholders.put(key, value);
            }
        }
    }

    public String replacePlaceholders(Player player, String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String result = text;
        if (this.plugin.isPlaceholderAPIEnabled()) {
            result = PlaceholderAPI.setPlaceholders((Player)player, (String)result);
        }
        result = this.replaceBuiltInPlaceholders(player, result);
        result = this.replaceCustomPlaceholders(player, result);
        return result;
    }

    private String replaceBuiltInPlaceholders(Player player, String text) {
        String result = text;
        if (player != null) {
            result = result.replace("%player%", player.getName());
            result = result.replace("%player_name%", player.getName());
            result = result.replace("%player_displayname%", player.getDisplayName());
            result = result.replace("%player_uuid%", player.getUniqueId().toString());
            result = result.replace("%player_world%", player.getWorld().getName());
            result = result.replace("%player_x%", String.valueOf(player.getLocation().getBlockX()));
            result = result.replace("%player_y%", String.valueOf(player.getLocation().getBlockY()));
            result = result.replace("%player_z%", String.valueOf(player.getLocation().getBlockZ()));
            result = result.replace("%player_health%", String.valueOf(Math.round(player.getHealth())));
            result = result.replace("%player_food%", String.valueOf(player.getFoodLevel()));
            result = result.replace("%player_level%", String.valueOf(player.getLevel()));
            result = result.replace("%player_exp%", String.valueOf(Math.round(player.getExp() * 100.0f)));
        }
        result = result.replace("%online_players%", String.valueOf(Bukkit.getOnlinePlayers().size()));
        result = result.replace("%max_players%", String.valueOf(Bukkit.getMaxPlayers()));
        result = result.replace("%server_name%", Bukkit.getServer().getName());
        result = result.replace("%server_version%", Bukkit.getVersion());
        result = result.replace("%server_bukkit_version%", Bukkit.getBukkitVersion());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        result = result.replace("%current_time%", dateFormat.format(new Date()));
        result = result.replace("%current_date%", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        result = result.replace("%current_time_short%", new SimpleDateFormat("HH:mm").format(new Date()));
        long uptimeMs = System.currentTimeMillis() - this.getServerStartTime();
        long uptimeSeconds = uptimeMs / 1000L;
        long uptimeMinutes = uptimeSeconds / 60L;
        long uptimeHours = uptimeMinutes / 60L;
        long uptimeDays = uptimeHours / 24L;
        String uptimeString = String.format("%dd %dh %dm", uptimeDays, uptimeHours % 24L, uptimeMinutes % 60L);
        result = result.replace("%server_uptime%", uptimeString);
        result = result.replace("%plugin_version%", this.plugin.getDescription().getVersion());
        result = result.replace("%joined_players_count%", String.valueOf(this.plugin.getFirstJoinManager().getJoinedPlayerCount()));
        result = result.replace("%active_cooldowns%", String.valueOf(this.plugin.getCooldownManager().getActiveCooldownCount()));
        return result;
    }

    private String replaceCustomPlaceholders(Player player, String text) {
        String result = text;
        for (Map.Entry<String, String> entry : this.customPlaceholders.entrySet()) {
            String placeholder = "%" + entry.getKey() + "%";
            String value = entry.getValue();
            if (this.plugin.isPlaceholderAPIEnabled()) {
                value = PlaceholderAPI.setPlaceholders((Player)player, (String)value);
            }
            value = this.replaceBuiltInPlaceholders(player, value);
            result = result.replace(placeholder, value);
        }
        return result;
    }

    private long getServerStartTime() {
        return System.currentTimeMillis() - System.currentTimeMillis() % 86400000L;
    }

    public void reloadCustomPlaceholders() {
        this.customPlaceholders.clear();
        this.loadCustomPlaceholders();
    }

    public Map<String, String> getCustomPlaceholders() {
        return new HashMap<String, String>(this.customPlaceholders);
    }

    public void addCustomPlaceholder(String key, String value) {
        this.customPlaceholders.put(key, value);
    }

    public void removeCustomPlaceholder(String key) {
        this.customPlaceholders.remove(key);
    }
}

