/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
class ReloadCommand
extends InventoriesCommand {
    private final MultiverseInventories plugin;

    @Inject
    ReloadCommand(@NotNull MultiverseInventories plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="reload")
    @CommandPermission(value="multiverse.inventories.reload")
    @Description(value="Reloads config file")
    void onReloadCommand(@NotNull MVCommandIssuer issuer) {
        this.plugin.reloadConfig();
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.RELOAD_COMPLETE);
    }

    @Service
    private static final class LegacyAlias
    extends ReloadCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiverseInventories plugin) {
            super(plugin);
        }

        @Override
        @CommandAlias(value="mvinvreload")
        void onReloadCommand(MVCommandIssuer issuer) {
            super.onReloadCommand(issuer);
        }
    }
}

