/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareReader;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareWriter;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
final class GiveCommand
extends InventoriesCommand {
    private final MultiverseInventories inventories;
    private final ProfileDataSource profileDataSource;

    @Inject
    GiveCommand(@NotNull MultiverseInventories inventories, @NotNull ProfileDataSource profileDataSource) {
        this.inventories = inventories;
        this.profileDataSource = profileDataSource;
    }

    @Subcommand(value="give")
    @CommandPermission(value="multiverse.inventories.give")
    @CommandCompletion(value="@players @mvworlds:scope=both @mvinvprofiletypes:checkPermissions=@mvinv-gamemode-profile-true|@materials:checkPermissions=@mvinv-gamemode-profile-false @materials:checkPermissions=@mvinv-gamemode-profile-true|@range:64,checkPermissions=@mvinv-gamemode-profile-false @range:64,checkPermissions=@mvinv-gamemode-profile-true|@empty @empty")
    @Syntax(value="<player> <world> [gamemode] <item> [amount]")
    @Description(value="World and Group Information")
    void onGiveCommand(MVCommandIssuer issuer, @Syntax(value="<player>") OfflinePlayer player, @Syntax(value="<world>") MultiverseWorld world, @Syntax(value="[gamemode]") ProfileType profileType, @Syntax(value="<item> [amount]") String item) {
        ItemStack itemStack = this.parseItemFromString(issuer, item);
        if (itemStack == null) {
            return;
        }
        InvLogging.finer("Giving player " + player.getName() + " item: " + String.valueOf(itemStack), new Object[0]);
        Player onlinePlayer = player.getPlayer();
        if (onlinePlayer != null && world.getName().equals(onlinePlayer.getWorld().getName()) && ProfileTypes.forPlayer(onlinePlayer).equals(profileType)) {
            onlinePlayer.getInventory().addItem(new ItemStack[]{itemStack});
            issuer.sendInfo("Gave player %s %s %s in world %s.".formatted(player.getName(), itemStack.getAmount(), itemStack, world.getName()), new MessageReplacement[0]);
            return;
        }
        ((CompletableFuture)SingleShareReader.of(this.inventories, player, world.getName(), profileType, Sharables.INVENTORY).read().thenCompose(inventory -> this.updatePlayerInventory(issuer, player, world, profileType, (ItemStack[])inventory, itemStack))).exceptionally(throwable -> {
            issuer.sendError(throwable.getMessage(), new MessageReplacement[0]);
            return null;
        });
    }

    @Nullable
    private ItemStack parseItemFromString(MVCommandIssuer issuer, String item) {
        String[] split;
        String itemName;
        Material material;
        int amount = 1;
        AtomicBoolean endIsAmount = new AtomicBoolean(false);
        int lastSpace = item.lastIndexOf(32);
        if (lastSpace != -1) {
            String amountString = item.substring(lastSpace + 1);
            amount = (Integer)Try.of((CheckedFunction0 & Serializable)() -> Integer.parseInt(amountString)).peek(ignore -> endIsAmount.set(true)).getOrElse((Object)1);
        }
        if (amount < 1) {
            issuer.sendError("You have to give at least 1 item.", new MessageReplacement[0]);
            return null;
        }
        if (amount > 6400) {
            issuer.sendError("Cannot give more than 6400 items at once.", new MessageReplacement[0]);
            return null;
        }
        if (endIsAmount.get()) {
            item = item.substring(0, lastSpace);
        }
        if ((material = Material.matchMaterial((String)(itemName = (split = REPatterns.get((String)"\\[").split(item, 2))[0]))) == null) {
            issuer.sendError("Invalid Material: " + split[0], new MessageReplacement[0]);
            return null;
        }
        ItemStack itemStack = new ItemStack(material, amount);
        if (split.length < 2) {
            return itemStack;
        }
        String additionalData = split[1];
        return (ItemStack)Try.of((CheckedFunction0 & Serializable)() -> Bukkit.getUnsafe().modifyItemStack(itemStack, String.valueOf(itemStack.getType().getKey()) + "[" + additionalData)).onFailure(throwable -> issuer.sendError(throwable.getMessage(), new MessageReplacement[0])).getOrNull();
    }

    private CompletableFuture<Void> updatePlayerInventory(MVCommandIssuer issuer, OfflinePlayer player, MultiverseWorld world, ProfileType profileType, @Nullable ItemStack[] inventory, @NotNull ItemStack itemStack) {
        this.putItemInInventory(inventory, itemStack);
        return ((CompletableFuture)SingleShareWriter.of(this.inventories, player, world.getName(), profileType, Sharables.INVENTORY).write(inventory, true).thenCompose(ignore -> player.isOnline() ? CompletableFuture.completedFuture(null) : this.profileDataSource.modifyGlobalProfile(GlobalProfileKey.of(player), profile -> profile.setLoadOnLogin(true)))).thenRun(() -> issuer.sendInfo("Gave player %s %s %s in world %s.".formatted(player.getName(), itemStack.getAmount(), itemStack.getI18NDisplayName(), world.getName()), new MessageReplacement[0]));
    }

    private void putItemInInventory(@Nullable ItemStack[] inventory, @NotNull ItemStack itemStack) {
        if (inventory == null) {
            inventory = new ItemStack[36];
        }
        int amountLeft = itemStack.getAmount();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || inventory[i].getType() == Material.AIR) {
                amountToGive = Math.min(amountLeft, itemStack.getMaxStackSize());
                inventory[i] = itemStack.clone();
                inventory[i].setAmount(amountToGive);
                amountLeft -= amountToGive;
            } else if (inventory[i].isSimilar(itemStack)) {
                amountToGive = Math.min(amountLeft, itemStack.getMaxStackSize() - inventory[i].getAmount());
                inventory[i].setAmount(inventory[i].getAmount() + amountToGive);
                amountLeft -= amountToGive;
            }
            if (amountLeft == 0) break;
        }
    }
}

