/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
class ListCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    ListCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="list")
    @CommandPermission(value="multiverse.inventories.list")
    @Description(value="World and Group Information")
    void onListCommand(@NotNull MVCommandIssuer issuer) {
        List<WorldGroup> groups = this.worldGroupManager.getGroups();
        String groupsString = "N/A";
        if (!groups.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (WorldGroup group : groups) {
                if (!builder.toString().isEmpty()) {
                    builder.append(", ");
                }
                builder.append(group.getName());
            }
            groupsString = builder.toString();
        }
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.LIST_GROUPS);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.LIST_GROUPS_INFO, new MessageReplacement[]{MessageReplacement.replace((String)"{groups}").with((Object)groupsString)});
    }

    @Service
    private static final class LegacyAlias
    extends ListCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(WorldGroupManager worldGroupManager) {
            super(worldGroupManager);
        }

        @Override
        @CommandAlias(value="mvinvlist|mvinvl")
        void onListCommand(MVCommandIssuer issuer) {
            super.onListCommand(issuer);
        }
    }
}

