/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport.multiinv;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.dataimport.DataImportException;
import org.mvplugins.multiverse.inventories.dataimport.multiinv.MIInventoryInterface;
import org.mvplugins.multiverse.inventories.dataimport.multiinv.MIPlayerFileLoader;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import uk.co.tggl.pluckerpluck.multiinv.MIYamlFiles;
import uk.co.tggl.pluckerpluck.multiinv.MultiInv;

final class MultiInvImportHelper {
    @NotNull
    private final MultiInv multiInv;
    private final WorldGroupManager worldGroupManager;
    private final InventoriesConfig inventoriesConfig;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final ProfileDataSource profileDataSource;

    MultiInvImportHelper(@NotNull MultiInv multiInv, @NotNull WorldGroupManager worldGroupManager, @NotNull InventoriesConfig inventoriesConfig, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull ProfileDataSource profileDataSource) {
        this.multiInv = multiInv;
        this.worldGroupManager = worldGroupManager;
        this.inventoriesConfig = inventoriesConfig;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.profileDataSource = profileDataSource;
    }

    void importData() throws DataImportException {
        WorldGroup defaultWorldGroup;
        HashMap<String, String> miGroupMap = this.getGroupMap();
        if (miGroupMap == null) {
            throw new DataImportException("There is no data to import from MultiInv!");
        }
        if (!miGroupMap.isEmpty() && (defaultWorldGroup = this.worldGroupManager.getDefaultGroup()) != null) {
            this.worldGroupManager.removeGroup(defaultWorldGroup);
            InvLogging.info("Removed automatically created world group in favor of imported groups.", new Object[0]);
        }
        for (Map.Entry<String, String> groupEntry : miGroupMap.entrySet()) {
            WorldGroup worldGroup = this.worldGroupManager.getGroup(groupEntry.getValue());
            if (worldGroup == null) {
                worldGroup = this.worldGroupManager.newEmptyGroup(groupEntry.getValue());
                worldGroup.getShares().mergeShares(Sharables.allOf());
                InvLogging.info("Importing group: " + groupEntry.getValue(), new Object[0]);
                this.worldGroupManager.updateGroup(worldGroup);
            }
            worldGroup.addWorld(groupEntry.getValue());
        }
        this.inventoriesConfig.save();
        for (OfflinePlayer player : Bukkit.getServer().getOfflinePlayers()) {
            String worldName;
            InvLogging.info("Processing MultiInv data for player: " + player.getName(), new Object[0]);
            for (Map.Entry<String, String> entry : miGroupMap.entrySet()) {
                worldName = entry.getKey();
                String groupName = entry.getValue();
                MIPlayerFileLoader playerFileLoader = new MIPlayerFileLoader(this.multiInv, player, groupName);
                if (!playerFileLoader.load()) continue;
                InvLogging.info("Processing MultiInv data for player: " + player.getName() + " for group: " + groupName, new Object[0]);
                this.mergeData(player, playerFileLoader, groupName, ContainerType.GROUP);
            }
            for (World world : Bukkit.getWorlds()) {
                worldName = world.getName();
                MIPlayerFileLoader playerFileLoader = new MIPlayerFileLoader(this.multiInv, player, worldName);
                if (!playerFileLoader.load()) continue;
                InvLogging.info("Processing MultiInv data for player: " + player.getName() + " for world only: " + worldName, new Object[0]);
                this.mergeData(player, playerFileLoader, worldName, ContainerType.WORLD);
            }
        }
    }

    private void mergeData(OfflinePlayer player, MIPlayerFileLoader playerFileLoader, String dataName, ContainerType type) {
        PlayerProfile playerProfile;
        if (type.equals((Object)ContainerType.GROUP)) {
            WorldGroup group = this.worldGroupManager.getGroup(dataName);
            if (group == null) {
                InvLogging.warning("Could not import player data for group: " + dataName, new Object[0]);
                return;
            }
            playerProfile = group.getGroupProfileContainer().getPlayerProfileNow(ProfileTypes.SURVIVAL, player);
        } else {
            playerProfile = this.profileContainerStoreProvider.getStore(type).getContainer(dataName).getPlayerProfileNow(ProfileTypes.SURVIVAL, player);
        }
        MIInventoryInterface inventoryInterface = playerFileLoader.getInventory(GameMode.SURVIVAL.toString());
        playerProfile.set(Sharables.INVENTORY, inventoryInterface.getInventoryContents());
        playerProfile.set(Sharables.ARMOR, inventoryInterface.getArmorContents());
        playerProfile.set(Sharables.HEALTH, playerFileLoader.getHealth());
        playerProfile.set(Sharables.SATURATION, Float.valueOf(playerFileLoader.getSaturation()));
        playerProfile.set(Sharables.EXPERIENCE, Float.valueOf(playerFileLoader.getExperience()));
        playerProfile.set(Sharables.TOTAL_EXPERIENCE, playerFileLoader.getTotalExperience());
        playerProfile.set(Sharables.LEVEL, playerFileLoader.getLevel());
        playerProfile.set(Sharables.FOOD_LEVEL, playerFileLoader.getHunger());
        this.profileDataSource.updatePlayerProfile(playerProfile);
    }

    private HashMap<String, String> getGroupMap() throws DataImportException {
        Field field;
        try {
            field = MIYamlFiles.class.getDeclaredField("groups");
        }
        catch (NoSuchFieldException nsfe) {
            throw new DataImportException("The running version of MultiInv is incompatible with the import feature.").setCauseException(nsfe);
        }
        field.setAccessible(true);
        HashMap miGroupMap = null;
        try {
            miGroupMap = (HashMap)field.get(null);
        }
        catch (ClassCastException | IllegalAccessException iae) {
            throw new DataImportException("The running version of MultiInv is incompatible with the import feature.").setCauseException(iae);
        }
        return miGroupMap;
    }
}

