/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.event.GameModeChangeShareHandlingEvent;
import org.mvplugins.multiverse.inventories.event.ShareHandlingEvent;
import org.mvplugins.multiverse.inventories.handleshare.ShareHandler;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.Perm;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class GameModeShareHandler
extends ShareHandler {
    private final GameMode fromGameMode;
    private final GameMode toGameMode;
    private final ProfileType fromType;
    private final ProfileType toType;
    private final String world;
    private final List<WorldGroup> worldGroups;

    public GameModeShareHandler(MultiverseInventories inventories, Player player, GameMode fromGameMode, GameMode toGameMode) {
        super(inventories, player);
        this.fromGameMode = fromGameMode;
        this.toGameMode = toGameMode;
        this.fromType = ProfileTypes.forGameMode(fromGameMode);
        this.toType = ProfileTypes.forGameMode(toGameMode);
        this.world = player.getWorld().getName();
        this.worldGroups = this.getAffectedWorldGroups();
    }

    private List<WorldGroup> getAffectedWorldGroups() {
        return this.worldGroupManager.getGroupsForWorld(this.world);
    }

    @Override
    protected ShareHandlingEvent createEvent() {
        return new GameModeChangeShareHandlingEvent(this.player, this.affectedProfiles, this.fromGameMode, this.toGameMode);
    }

    @Override
    protected void prepareProfiles() {
        InvLogging.fine("=== " + this.player.getName() + " changing game mode from: " + String.valueOf(this.fromType) + " to: " + String.valueOf(this.toType) + " for world: " + this.world + " ===", new Object[0]);
        if (this.isPlayerAffectedByChange()) {
            this.addProfiles();
        } else if (this.inventoriesConfig.getAlwaysWriteWorldProfile()) {
            this.affectedProfiles.addWriteProfile(this.worldProfileContainerStore.getContainer(this.world).getProfileKey(this.fromType, (OfflinePlayer)this.player), this.worldGroups.isEmpty() && !this.inventoriesConfig.getUseOptionalsForUngroupedWorlds() ? Sharables.standard() : Sharables.enabled());
        }
    }

    private boolean isPlayerAffectedByChange() {
        if (this.isPlayerBypassingChange()) {
            this.logBypass();
            return false;
        }
        return true;
    }

    private boolean isPlayerBypassingChange() {
        return Perm.BYPASS_WORLD.hasBypass(this.player, this.world) || Perm.BYPASS_GAME_MODE.hasBypass(this.player, this.toGameMode.name().toLowerCase());
    }

    private void addProfiles() {
        Shares handledShares = Sharables.noneOf();
        this.worldGroups.forEach(worldGroup -> this.addProfilesForWorldGroup(handledShares, (WorldGroup)worldGroup));
        Shares unhandledShares = this.worldGroups.isEmpty() && !this.inventoriesConfig.getUseOptionalsForUngroupedWorlds() ? Sharables.standardOf() : Sharables.enabledOf();
        unhandledShares.removeAll(handledShares);
        if (!unhandledShares.isEmpty()) {
            this.affectedProfiles.addReadProfile(this.worldProfileContainerStore.getContainer(this.world).getProfileKey(this.toType, (OfflinePlayer)this.player), unhandledShares);
        }
        if (this.inventoriesConfig.getAlwaysWriteWorldProfile()) {
            this.affectedProfiles.addWriteProfile(this.worldProfileContainerStore.getContainer(this.world).getProfileKey(this.fromType, (OfflinePlayer)this.player), this.inventoriesConfig.getUseOptionalsForUngroupedWorlds() ? Sharables.enabled() : Sharables.standard());
        } else if (!unhandledShares.isEmpty()) {
            this.affectedProfiles.addWriteProfile(this.worldProfileContainerStore.getContainer(this.world).getProfileKey(this.fromType, (OfflinePlayer)this.player), unhandledShares);
        }
    }

    private void addProfilesForWorldGroup(Shares handledShares, WorldGroup worldGroup) {
        ProfileContainer container = worldGroup.getGroupProfileContainer();
        this.affectedProfiles.addWriteProfile(container.getProfileKey(this.fromType, (OfflinePlayer)this.player), worldGroup.getApplicableShares());
        this.affectedProfiles.addReadProfile(container.getProfileKey(this.toType, (OfflinePlayer)this.player), worldGroup.getApplicableShares());
        handledShares.addAll(worldGroup.getApplicableShares());
        handledShares.addAll(worldGroup.getDisabledShares());
    }
}

