/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.util.List;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.event.ReadOnlyShareHandlingEvent;
import org.mvplugins.multiverse.inventories.event.ShareHandlingEvent;
import org.mvplugins.multiverse.inventories.handleshare.ShareHandler;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;

public final class ReadOnlyShareHandler
extends ShareHandler {
    public ReadOnlyShareHandler(MultiverseInventories inventories, Player player) {
        super(inventories, player);
    }

    @Override
    protected void prepareProfiles() {
        List<WorldGroup> worldGroups = this.worldGroupManager.getGroupsForWorld(this.player.getWorld().getName());
        Shares unhandledShares = Sharables.enabledOf();
        for (WorldGroup worldGroup : worldGroups) {
            this.affectedProfiles.addReadProfile(worldGroup.getGroupProfileContainer().getProfileKey(this.player), worldGroup.getApplicableShares());
            unhandledShares.removeAll(worldGroup.getApplicableShares());
        }
        if (!unhandledShares.isEmpty()) {
            this.affectedProfiles.addReadProfile(this.worldProfileContainerStore.getContainer(this.player.getWorld().getName()).getProfileKey(this.player), unhandledShares);
        }
    }

    @Override
    protected ShareHandlingEvent createEvent() {
        return new ReadOnlyShareHandlingEvent(this.player, this.affectedProfiles);
    }
}

