/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.container;

import java.util.EnumMap;
import java.util.Map;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStore;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;

@Service
public class ProfileContainerStoreProvider {
    private final Map<ContainerType, ProfileContainerStore> stores;
    private final MultiverseInventories inventories;

    @Inject
    ProfileContainerStoreProvider(@NotNull MultiverseInventories inventories) {
        this.inventories = inventories;
        this.stores = new EnumMap<ContainerType, ProfileContainerStore>(ContainerType.class);
    }

    public ProfileContainerStore getStore(ContainerType type) {
        return this.stores.computeIfAbsent(type, t -> new ProfileContainerStore(this.inventories, (ContainerType)((Object)t)));
    }

    public void clearCache() {
        this.stores.clear();
    }
}

