/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.key;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

public final class ProfileTypes {
    private static final Set<ProfileType> types = new HashSet<ProfileType>();
    private static InventoriesConfig config;
    public static final ProfileType SURVIVAL;
    public static final ProfileType CREATIVE;
    public static final ProfileType ADVENTURE;
    public static final ProfileType SPECTATOR;

    public static void init(MultiverseInventories plugin) {
        config = (InventoriesConfig)plugin.getServiceLocator().getService(InventoriesConfig.class, new Annotation[0]);
    }

    private static ProfileType createProfileType(String name) {
        ProfileType type = ProfileType.createProfileType(name);
        types.add(type);
        return type;
    }

    public static Collection<ProfileType> getTypes() {
        return types;
    }

    public static Collection<ProfileType> getApplicableTypes() {
        if (config != null && config.getEnableGamemodeShareHandling()) {
            return types;
        }
        return List.of(ProfileTypes.getDefault());
    }

    public static ProfileType getDefault() {
        return SURVIVAL;
    }

    public static ProfileType forPlayer(Player player) {
        if (config != null && config.getEnableGamemodeShareHandling()) {
            return ProfileTypes.forGameMode(player.getGameMode());
        }
        return ProfileTypes.getDefault();
    }

    public static Option<ProfileType> forName(String name) {
        return Option.ofOptional(types.stream().filter(type -> type.getName().equalsIgnoreCase(name)).findFirst());
    }

    public static ProfileType forGameMode(GameMode mode) {
        return switch (mode) {
            case GameMode.SURVIVAL -> SURVIVAL;
            case GameMode.CREATIVE -> CREATIVE;
            case GameMode.ADVENTURE -> ADVENTURE;
            case GameMode.SPECTATOR -> SPECTATOR;
            default -> SURVIVAL;
        };
    }

    public static boolean isAll(ProfileType[] otherTypes) {
        return Set.of(otherTypes).equals(types);
    }

    private ProfileTypes() {
        throw new IllegalStateException();
    }

    static {
        SURVIVAL = ProfileTypes.createProfileType("SURVIVAL");
        CREATIVE = ProfileTypes.createProfileType("CREATIVE");
        ADVENTURE = ProfileTypes.createProfileType("ADVENTURE");
        SPECTATOR = ProfileTypes.createProfileType("SPECTATOR");
    }
}

