/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.share;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.mvplugins.multiverse.inventories.MultiverseInventoriesApi;
import org.mvplugins.multiverse.inventories.share.SharableSerializer;
import org.mvplugins.multiverse.inventories.util.ItemStackConverter;
import org.mvplugins.multiverse.inventories.util.MinecraftTools;

abstract class InventorySerializer
implements SharableSerializer<ItemStack[]> {
    InventorySerializer() {
    }

    @Override
    public ItemStack[] deserialize(Object obj) {
        return this.unmapSlots(obj);
    }

    @Override
    public Object serialize(ItemStack[] itemStacks) {
        return this.mapSlots(itemStacks);
    }

    private Map<String, Object> mapSlots(ItemStack[] itemStacks) {
        HashMap<String, Object> result = new HashMap<String, Object>(itemStacks.length);
        for (int i = 0; i < itemStacks.length; ++i) {
            Object serialize = ItemStackConverter.serialize(itemStacks[i]);
            if (serialize == null) continue;
            result.put(Integer.toString(i), serialize);
        }
        return result;
    }

    private ItemStack[] unmapSlots(Object obj) {
        ItemStack[] inventory = new ItemStack[this.getInventorySize()];
        if (!(obj instanceof Map)) {
            return MinecraftTools.fillWithAir(inventory);
        }
        Map invMap = (Map)obj;
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item;
            Object value = invMap.get(Integer.toString(i));
            inventory[i] = value == null ? new ItemStack(Material.AIR) : ((item = ItemStackConverter.deserialize(value)) == null ? new ItemStack(Material.AIR) : item);
        }
        return inventory;
    }

    protected abstract int getInventorySize();

    static final class ArmorSerializer
    extends InventorySerializer {
        ArmorSerializer() {
        }

        @Override
        protected int getInventorySize() {
            return MultiverseInventoriesApi.get().getInventoriesConfig().getMaxArmorItemsSize();
        }
    }

    static final class EnderChestSerializer
    extends InventorySerializer {
        EnderChestSerializer() {
        }

        @Override
        protected int getInventorySize() {
            return MultiverseInventoriesApi.get().getInventoriesConfig().getMaxEnderChestItemsSize();
        }
    }

    static final class MainInventorySerializer
    extends InventorySerializer {
        MainInventorySerializer() {
        }

        @Override
        protected int getInventorySize() {
            return MultiverseInventoriesApi.get().getInventoriesConfig().getMaxInventoryItemsSize();
        }
    }
}

