/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.command;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandContexts;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandExecutionContext;
import org.mvplugins.multiverse.external.acf.commands.InvalidCommandArgument;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.PlayerNamesMapper;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
public final class MVInvCommandContexts {
    private final WorldGroupManager worldGroupManager;
    private final PlayerNamesMapper playerNamesMapper;
    private final InventoriesConfig config;
    private final ProfileDataSource profileDataSource;

    @Inject
    private MVInvCommandContexts(@NotNull MVCommandManager commandManager, @NotNull WorldGroupManager worldGroupManager, @NotNull PlayerNamesMapper playerNamesMapper, @NotNull InventoriesConfig config, @NotNull ProfileDataSource profileDataSource) {
        this.worldGroupManager = worldGroupManager;
        this.playerNamesMapper = playerNamesMapper;
        this.config = config;
        this.profileDataSource = profileDataSource;
        MVCommandContexts commandContexts = commandManager.getCommandContexts();
        commandContexts.registerContext(ContainerKey[].class, this::parseContainerKeyArray);
        commandContexts.registerContext(GlobalProfileKey[].class, this::parseGlobalProfileKeyArray);
        commandContexts.registerIssuerAwareContext(ProfileType.class, this::parseProfileType);
        commandContexts.registerIssuerAwareContext(ProfileType[].class, this::parseProfileTypeArray);
        commandContexts.registerContext(Sharable.class, this::parseSharable);
        commandContexts.registerContext(Shares.class, this::parseShares);
        commandContexts.registerContext(WorldGroup.class, this::parseWorldGroup);
    }

    private ProfileType parseProfileType(BukkitCommandExecutionContext context) {
        if (!this.config.getEnableGamemodeShareHandling()) {
            return ProfileTypes.getDefault();
        }
        String profileType = context.popFirstArg();
        return (ProfileType)ProfileTypes.forName(profileType).getOrElseThrow(() -> new InvalidCommandArgument("Invalid profile type: " + profileType));
    }

    private ContainerKey[] parseContainerKeyArray(BukkitCommandExecutionContext context) {
        String[] typesSplit;
        String keyStrings = context.popFirstArg();
        if (keyStrings.equals("@all")) {
            return (ContainerKey[])Arrays.stream(ContainerType.values()).flatMap(containerType -> this.profileDataSource.listContainerDataNames((ContainerType)((Object)containerType)).stream().map(containerName -> ContainerKey.create(containerType, containerName))).toArray(ContainerKey[]::new);
        }
        ArrayList<ContainerKey> containerKeys = new ArrayList<ContainerKey>();
        for (String typeSplit : typesSplit = REPatterns.SEMICOLON.split(keyStrings)) {
            String[] keyValueSplit = REPatterns.EQUALS.split(typeSplit, 2);
            if (keyValueSplit.length != 2) continue;
            ContainerType containerType2 = ContainerType.valueOf(keyValueSplit[0].toUpperCase());
            String[] dataNameSplit = REPatterns.COMMA.split(keyValueSplit[1]);
            List<String> availableDataNames = this.profileDataSource.listContainerDataNames(containerType2);
            for (String dataName : dataNameSplit) {
                if (!availableDataNames.contains(dataName)) continue;
                containerKeys.add(ContainerKey.create(containerType2, dataName));
            }
        }
        return containerKeys.toArray(new ContainerKey[0]);
    }

    private GlobalProfileKey[] parseGlobalProfileKeyArray(BukkitCommandExecutionContext context) {
        String keyStrings = context.popFirstArg();
        if (keyStrings.equals("@all")) {
            return (GlobalProfileKey[])this.playerNamesMapper.getKeys().toArray(GlobalProfileKey[]::new);
        }
        String[] profileNames = REPatterns.COMMA.split(keyStrings);
        return (GlobalProfileKey[])Arrays.stream(profileNames).map(this.playerNamesMapper::getKey).filter(Option::isDefined).map(Option::get).toArray(GlobalProfileKey[]::new);
    }

    private ProfileType[] parseProfileTypeArray(BukkitCommandExecutionContext context) {
        String keyStrings = context.popFirstArg();
        if (keyStrings.equals("@all")) {
            return (ProfileType[])ProfileTypes.getTypes().toArray(ProfileType[]::new);
        }
        String[] profileNames = REPatterns.COMMA.split(keyStrings);
        return (ProfileType[])Arrays.stream(profileNames).map(ProfileTypes::forName).filter(Option::isDefined).map(Option::get).toArray(ProfileType[]::new);
    }

    private Sharable<?> parseSharable(BukkitCommandExecutionContext context) {
        String sharableName = context.popFirstArg();
        Sharable targetSharable = Sharables.all().stream().filter(sharable -> sharable.getNames().length > 0).filter(sharable -> sharable.getNames()[0].equals(sharableName)).findFirst().orElse(null);
        if (targetSharable != null) {
            return targetSharable;
        }
        if (context.isOptional()) {
            return null;
        }
        throw new InvalidCommandArgument((MessageKeyProvider)MVInvi18n.ERROR_NOSHARESSPECIFIED, new String[0]);
    }

    private Shares parseShares(BukkitCommandExecutionContext context) {
        String shareStrings = context.popFirstArg();
        if (Strings.isNullOrEmpty((String)shareStrings)) {
            throw new InvalidCommandArgument((MessageKeyProvider)MVInvi18n.ERROR_NOSHARESSPECIFIED, new String[0]);
        }
        String[] shareNames = shareStrings.split(",");
        Shares newShares = Sharables.noneOf();
        Shares negativeShares = Sharables.noneOf();
        for (String shareName : shareNames) {
            if (shareName.startsWith("-")) {
                shareName = shareName.substring(1);
                Option.of((Object)Sharables.lookup(shareName)).peek(shares -> negativeShares.setSharing((Shares)shares, true));
                continue;
            }
            Option.of((Object)Sharables.lookup(shareName)).peek(shares -> newShares.setSharing((Shares)shares, true));
        }
        newShares.setSharing(negativeShares, false);
        if (newShares.isEmpty()) {
            throw new InvalidCommandArgument((MessageKeyProvider)MVInvi18n.ERROR_NOSHARESSPECIFIED, new String[0]);
        }
        return newShares;
    }

    private WorldGroup parseWorldGroup(BukkitCommandExecutionContext context) {
        String groupName = context.popFirstArg();
        WorldGroup group = this.worldGroupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        if (context.isOptional()) {
            return null;
        }
        throw new InvalidCommandArgument((MessageKeyProvider)MVInvi18n.ERROR_NOGROUP, new String[0]);
    }
}

