/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
class ToggleCommand
extends InventoriesCommand {
    private final InventoriesConfig inventoriesConfig;

    @Inject
    ToggleCommand(@NotNull InventoriesConfig inventoriesConfig) {
        this.inventoriesConfig = inventoriesConfig;
    }

    @Subcommand(value="toggle")
    @CommandPermission(value="multiverse.inventories.addshares")
    @CommandCompletion(value="@sharables:scope=optional")
    @Syntax(value="<share-name>")
    @Description(value="Toggles the usage of optional sharables")
    void onToggleCommand(@NotNull MVCommandIssuer issuer, @Single @Syntax(value="<share-name>") @Description(value="Share to toggle") @NotNull Sharable<?> sharable) {
        Shares optionalShares = this.inventoriesConfig.getActiveOptionalShares();
        if (!sharable.isOptional()) {
            issuer.sendError((MessageKeyProvider)MVInvi18n.TOGGLE_NOOPTIONALSHARES, new MessageReplacement[]{MessageReplacement.replace((String)"{share}").with((Object)sharable.toString())});
            return;
        }
        if (optionalShares.contains(sharable)) {
            optionalShares.remove(sharable);
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.TOGGLE_NOWNOTUSINGOPTIONAL, new MessageReplacement[]{MessageReplacement.replace((String)"{share}").with((Object)sharable.getNames()[0])});
        } else {
            optionalShares.add(sharable);
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.TOGGLE_NOWUSINGOPTIONAL, new MessageReplacement[]{MessageReplacement.replace((String)"{share}").with((Object)sharable.getNames()[0])});
        }
        this.inventoriesConfig.setActiveOptionalShares(optionalShares);
        this.inventoriesConfig.save();
    }

    @Service
    private static final class LegacyAlias
    extends ToggleCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(InventoriesConfig inventoriesConfig) {
            super(inventoriesConfig);
        }

        @Override
        @CommandAlias(value="mvinvtoggle")
        void onToggleCommand(MVCommandIssuer issuer, Sharable<?> sharable) {
            super.onToggleCommand(issuer, sharable);
        }
    }
}

