/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit;

import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jvnet.hk2.annotations.Contract;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditCreator;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditResult;

@Contract
@ApiStatus.Internal
public abstract class BulkEditCommand
extends InventoriesCommand {
    protected final BulkEditCreator bulkEditCreator;

    @Inject
    protected BulkEditCommand(BulkEditCreator bulkEditCreator) {
        this.bulkEditCreator = bulkEditCreator;
    }

    protected void outputActionSummary(MVCommandIssuer issuer, BulkEditAction<?> bulkEditAction) {
        issuer.sendMessage("Summary of affected profiles:");
        bulkEditAction.getActionSummary().forEach((key, value) -> issuer.sendMessage("  %s: %s".formatted(key, value.size() > 10 ? Integer.valueOf(value.size()) : StringFormatter.join((Collection)value, (String)", "))));
    }

    protected void runBulkEditAction(MVCommandIssuer issuer, BulkEditAction<?> bulkEditAction) {
        issuer.sendMessage("Starting bulk edit action...");
        bulkEditAction.execute().thenAccept(result -> this.outputResult(issuer, (BulkEditResult)result));
    }

    protected void outputResult(MVCommandIssuer issuer, BulkEditResult bulkEditResult) {
        issuer.sendMessage("Successfully processed %d profiles!".formatted(bulkEditResult.getSuccessCount()));
        if (bulkEditResult.getFailureCount() > 0) {
            issuer.sendError("Failed to process %d profiles! See log for details.".formatted(bulkEditResult.getFailureCount()), new MessageReplacement[0]);
        }
        issuer.sendMessage("Bulk edit action completed in %.4f ms.".formatted(bulkEditResult.getTimeTaken()));
    }
}

