/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditResult;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Experimental
public abstract class BulkEditAction<K extends GlobalProfileKey> {
    protected final MultiverseInventories inventories;
    protected final ProfileDataSource profileDataSource;
    protected final GlobalProfileKey[] globalProfileKeys;

    BulkEditAction(MultiverseInventories inventories, GlobalProfileKey[] globalProfileKeys) {
        this.inventories = inventories;
        this.profileDataSource = (ProfileDataSource)inventories.getServiceLocator().getService(ProfileDataSource.class, new Annotation[0]);
        this.globalProfileKeys = globalProfileKeys;
    }

    public CompletableFuture<BulkEditResult> execute() {
        BulkEditResult bulkEditResult = new BulkEditResult();
        List<K> targetKeys = this.aggregateKeys();
        HashSet onlinePlayers = new HashSet();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])targetKeys.stream().map(key -> {
            Player player = key.getOnlinePlayer();
            if (player != null && this.isOnlinePlayerAffected(key, player)) {
                onlinePlayers.add(player);
            }
            return ((CompletableFuture)this.performAction(key).thenRun(bulkEditResult::incrementSuccess)).exceptionally(throwable -> {
                bulkEditResult.incrementFailure();
                throwable.printStackTrace();
                return null;
            });
        }).toArray(CompletableFuture[]::new)).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)this.inventories, () -> onlinePlayers.forEach(this::updateOnlinePlayerNow)))).thenApply(ignore -> bulkEditResult);
    }

    protected abstract List<K> aggregateKeys();

    protected abstract CompletableFuture<Void> performAction(K var1);

    protected boolean isOnlinePlayerAffected(K key, Player player) {
        return ((GlobalProfileKey)key).getPlayerUUID().equals(player.getUniqueId());
    }

    protected abstract void updateOnlinePlayerNow(Player var1);

    public Map<String, List<String>> getActionSummary() {
        return Map.of("Players", Arrays.stream(this.globalProfileKeys).map(GlobalProfileKey::getPlayerName).toList());
    }
}

