/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

final class InventoriesDupingPatch {
    private static final int SLOT_TIMEOUT = 5;
    private int updateTimeoutsTaskId = -1;
    private final Map<UUID, Integer> timeouts = new HashMap<UUID, Integer>();
    private final Listener listener = new Listener(){

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerJoin(PlayerJoinEvent event) {
            InventoriesDupingPatch.this.timeouts.remove(event.getPlayer().getUniqueId());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerQuit(PlayerQuitEvent event) {
            InventoriesDupingPatch.this.timeouts.remove(event.getPlayer().getUniqueId());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
            if (InventoriesDupingPatch.this.updateTimeoutsTaskId != -1) {
                InventoriesDupingPatch.this.timeouts.put(event.getPlayer().getUniqueId(), 5);
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onCreativeSlotChange(InventoryCreativeEvent event) {
            Player player;
            if (InventoriesDupingPatch.this.timeouts.isEmpty()) {
                return;
            }
            InventoryHolder holder = event.getInventory().getHolder();
            if (holder instanceof Player && InventoriesDupingPatch.this.timeouts.containsKey((player = (Player)holder).getUniqueId())) {
                event.setResult(Event.Result.DENY);
            }
        }
    };

    InventoriesDupingPatch() {
    }

    static InventoriesDupingPatch enableDupingPatch(Plugin plugin) {
        InventoriesDupingPatch patch = new InventoriesDupingPatch();
        patch.enable(plugin);
        return patch;
    }

    public void enable(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents(this.listener, plugin);
        this.updateTimeoutsTaskId = Bukkit.getScheduler().runTaskTimer(plugin, (Runnable)new UpdateTimeoutsTask(), 1L, 1L).getTaskId();
    }

    public void disable() {
        if (this.updateTimeoutsTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.updateTimeoutsTaskId);
            this.updateTimeoutsTaskId = -1;
        }
        this.timeouts.clear();
    }

    private final class UpdateTimeoutsTask
    implements Runnable {
        private UpdateTimeoutsTask() {
        }

        @Override
        public void run() {
            if (InventoriesDupingPatch.this.timeouts.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<UUID, Integer>> iter = InventoriesDupingPatch.this.timeouts.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<UUID, Integer> e = iter.next();
                int value = e.getValue() - 1;
                if (value > 0) {
                    e.setValue(value);
                    continue;
                }
                iter.remove();
            }
        }
    }
}

