/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.inject.PluginServiceLocator;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.dataimport.DataImportManager;
import org.mvplugins.multiverse.inventories.profile.PlayerNamesMapper;
import org.mvplugins.multiverse.inventories.profile.ProfileCacheManager;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;

public final class MultiverseInventoriesApi {
    private static MultiverseInventoriesApi instance;
    private final PluginServiceLocator serviceLocator;

    static void init(@NotNull MultiverseInventories multiverseInventories) {
        if (instance != null) {
            throw new IllegalStateException("MultiverseCoreApi has already been initialized!");
        }
        instance = new MultiverseInventoriesApi(multiverseInventories.getServiceLocator());
        Bukkit.getServicesManager().register(MultiverseInventoriesApi.class, (Object)instance, (Plugin)multiverseInventories, ServicePriority.Normal);
    }

    static void shutdown() {
        Bukkit.getServicesManager().unregister((Object)instance);
        instance = null;
    }

    @NotNull
    public static MultiverseInventoriesApi get() {
        if (instance == null) {
            throw new IllegalStateException("MultiverseInventoriesApi has not been initialized!");
        }
        return instance;
    }

    private MultiverseInventoriesApi(@NotNull PluginServiceLocator serviceProvider) {
        this.serviceLocator = serviceProvider;
    }

    @NotNull
    public DataImportManager getDataImportManager() {
        return Objects.requireNonNull((DataImportManager)this.serviceLocator.getService(DataImportManager.class, new Annotation[0]));
    }

    @NotNull
    public InventoriesConfig getInventoriesConfig() {
        return Objects.requireNonNull((InventoriesConfig)this.serviceLocator.getService(InventoriesConfig.class, new Annotation[0]));
    }

    @NotNull
    public PlayerNamesMapper getPlayerNamesMapper() {
        return Objects.requireNonNull((PlayerNamesMapper)this.serviceLocator.getService(PlayerNamesMapper.class, new Annotation[0]));
    }

    @NotNull
    public ProfileCacheManager getProfileCacheManager() {
        return Objects.requireNonNull((ProfileCacheManager)this.serviceLocator.getService(ProfileCacheManager.class, new Annotation[0]));
    }

    @NotNull
    public ProfileContainerStoreProvider getProfileContainerStoreProvider() {
        return Objects.requireNonNull((ProfileContainerStoreProvider)this.serviceLocator.getService(ProfileContainerStoreProvider.class, new Annotation[0]));
    }

    @NotNull
    public ProfileDataSource getProfileDataSource() {
        return Objects.requireNonNull((ProfileDataSource)this.serviceLocator.getService(ProfileDataSource.class, new Annotation[0]));
    }

    @NotNull
    public WorldGroupManager getWorldGroupManager() {
        return Objects.requireNonNull((WorldGroupManager)this.serviceLocator.getService(WorldGroupManager.class, new Annotation[0]));
    }

    @NotNull
    public PluginServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }
}

