/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Conditions;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class CreateGroupCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    CreateGroupCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="create-group")
    @CommandPermission(value="multiverse.inventories.creategroup")
    @CommandCompletion(value="@empty @mvworlds:multiple,scope=both @shares")
    @Syntax(value="<name> [share[,extra]] [world[,extra]]")
    @Description(value="Creates a new empty World Group with no worlds and no shares.")
    void onCreateGroupCommand(MVCommandIssuer issuer, @Conditions(value="newWorldGroupName") @Syntax(value="<name>") @Description(value="New group name to create.") @NotNull String groupName, @Optional @Syntax(value="[world[,extra]]") String worlds, @Optional @Syntax(value="[share,[extra]]") Shares shares) {
        WorldGroup worldGroup = this.worldGroupManager.newEmptyGroup(groupName);
        if (worlds != null) {
            worldGroup.addWorlds(List.of(REPatterns.COMMA.split(worlds)), false);
        }
        if (shares != null) {
            worldGroup.getShares().mergeShares(shares);
        }
        this.worldGroupManager.updateGroup(worldGroup);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.GROUP_CREATIONCOMPLETE, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)groupName)});
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFO, new MessageReplacement[]{MessageReplacement.replace((String)"{worlds}").with(worldGroup.getConfigWorlds())});
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFOSHARES, new MessageReplacement[]{MessageReplacement.replace((String)"{shares}").with((Object)worldGroup.getShares())});
        this.worldGroupManager.checkForConflicts().sendConflictIssue(issuer);
    }
}

