/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import com.google.common.io.Files;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.World;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.data.ProfileData;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.profile.nbt.PlayerDataExtractor;

@Service
final class PlayerDataImportCommand
extends InventoriesCommand {
    private final PlayerDataExtractor playerDataExtractor;
    private final ProfileDataSource profileDataSource;

    @Inject
    PlayerDataImportCommand(PlayerDataExtractor playerDataExtractor, ProfileDataSource profileDataSource) {
        this.playerDataExtractor = playerDataExtractor;
        this.profileDataSource = profileDataSource;
    }

    @Subcommand(value="playerdata import")
    @Syntax(value="<world>")
    @CommandPermission(value="multiverse.inventories.importplayerdata")
    @CommandCompletion(value="@worldwithplayerdata")
    @Description(value="Import player data from the world's playerdata folder.")
    void onCommand(MVCommandIssuer issuer, World world) {
        Path worldPath = world.getWorldFolder().toPath();
        File playerDataPath = worldPath.resolve("playerdata").toFile();
        if (!playerDataPath.isDirectory()) {
            issuer.sendMessage("World's playerdata folder does not exist: " + world.getName());
            return;
        }
        ArrayList playerDataFutures = new ArrayList();
        File[] files = playerDataPath.listFiles();
        if (files == null) {
            issuer.sendMessage("No player data files found in the world's playerdata folder: " + world.getName());
            return;
        }
        for (File playerDataFile : files) {
            if (!Files.getFileExtension((String)playerDataFile.getName()).equals("dat")) continue;
            UUID playerUUID = UUID.fromString(Files.getNameWithoutExtension((String)playerDataFile.getName()));
            this.playerDataExtractor.extract(playerDataFile.toPath()).onSuccess(profileData -> playerDataFutures.add(((CompletableFuture)((CompletableFuture)this.profileDataSource.getGlobalProfile(GlobalProfileKey.of(playerUUID)).thenCompose(this.profileDataSource::updateGlobalProfile)).thenCompose(ignore -> this.profileDataSource.getPlayerProfile(ProfileKey.of(ContainerType.WORLD, world.getName(), ProfileTypes.getDefault(), playerUUID)))).thenCompose(playerProfile -> {
                playerProfile.update((ProfileData)profileData);
                return this.profileDataSource.updatePlayerProfile((PlayerProfile)playerProfile);
            })));
        }
        CompletableFuture.allOf(playerDataFutures.toArray(new CompletableFuture[0])).thenRun(() -> issuer.sendMessage("Successfully imported all player data from " + world.getName() + "."));
    }
}

