/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.prompts;

import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.prompts.InventoriesPrompt;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

final class GroupSharesPrompt
extends InventoriesPrompt {
    protected final WorldGroup group;
    protected final Prompt nextPrompt;
    protected final boolean isCreating;
    protected final Shares shares;

    public GroupSharesPrompt(MultiverseInventories plugin, MVCommandIssuer issuer, WorldGroup group, Prompt nextPrompt, boolean creatingGroup) {
        super(plugin, issuer);
        this.group = group;
        this.nextPrompt = nextPrompt;
        this.isCreating = creatingGroup;
        this.shares = Sharables.fromShares(group.getShares());
    }

    @Override
    @NotNull
    public Message getPromptMessage(@NotNull ConversationContext conversationContext) {
        StringBuilder builder = new StringBuilder();
        for (Sharable sharable : this.shares) {
            if (builder.isEmpty()) {
                builder.append(ChatColor.WHITE);
            } else {
                builder.append(ChatColor.GOLD).append(", ").append(ChatColor.WHITE);
            }
            builder.append(sharable.toString());
        }
        return Message.of((MessageKeyProvider)MVInvi18n.GROUP_SHARESPROMPT, (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)this.group.getName()), MessageReplacement.replace((String)"{shares}").with((Object)builder.toString())});
    }

    public Prompt acceptInput(@NotNull ConversationContext conversationContext, String input) {
        if ("@".equals(input)) {
            this.group.getShares().clear();
            this.group.getShares().addAll(this.shares);
            this.worldGroupManager.updateGroup(this.group);
            if (this.isCreating) {
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.GROUP_CREATIONCOMPLETE, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)this.group.getName())});
            } else {
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.GROUP_UPDATED);
            }
            this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)this.group.getName())});
            this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFO, new MessageReplacement[]{MessageReplacement.replace((String)"{worlds}").with(this.group.getConfigWorlds())});
            this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFOSHARES, new MessageReplacement[]{MessageReplacement.replace((String)"{shares}").with((Object)this.group.getShares())});
            this.worldGroupManager.checkForConflicts().sendConflictIssue(this.issuer);
            return this.nextPrompt;
        }
        boolean negative = false;
        Shares shares = Sharables.lookup(input.toLowerCase());
        if (shares == null && input.startsWith("-") && input.length() > 1) {
            negative = true;
            shares = Sharables.lookup(input.toLowerCase().substring(1));
        }
        if (shares == null) {
            this.issuer.sendError((MessageKeyProvider)MVInvi18n.ERROR_NOSHARESSPECIFIED);
            return this;
        }
        if (negative) {
            this.shares.removeAll(shares);
            return this;
        }
        this.shares.addAll(shares);
        return this;
    }
}

