/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport.multiinv;

import java.io.File;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.mvplugins.multiverse.inventories.dataimport.multiinv.MIInventoryInterface;
import org.mvplugins.multiverse.inventories.dataimport.multiinv.MIInventoryOldWrapper;
import org.mvplugins.multiverse.inventories.dataimport.multiinv.MIInventoryWrapper;
import uk.co.tggl.pluckerpluck.multiinv.MultiInv;

final class MIPlayerFileLoader {
    private final YamlConfiguration playerFile;
    private final File file;

    public MIPlayerFileLoader(MultiInv plugin, OfflinePlayer player, String group) {
        File worldsFolder = new File(plugin.getDataFolder(), "Groups");
        this.file = new File(worldsFolder, group + File.separator + player.getName() + ".yml");
        this.playerFile = new YamlConfiguration();
    }

    public boolean load() {
        if (this.file.exists()) {
            try {
                this.playerFile.load(this.file);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public MIInventoryInterface getInventory(String inventoryName) {
        String inventoryString = this.playerFile.getString(inventoryName, null);
        MIInventoryInterface inventory = inventoryString == null || inventoryString.contains(";-;") ? new MIInventoryOldWrapper(inventoryString) : new MIInventoryWrapper(inventoryString);
        return inventory;
    }

    public double getHealth() {
        double health = this.playerFile.getDouble("health", 20.0);
        if (health <= 0.0 || health > 20.0) {
            health = 20.0;
        }
        return health;
    }

    public int getHunger() {
        int hunger = this.playerFile.getInt("hunger", 20);
        if (hunger <= 0 || hunger > 20) {
            hunger = 20;
        }
        return hunger;
    }

    public float getSaturation() {
        double saturationDouble = this.playerFile.getDouble("saturation", 0.0);
        float saturation = (float)saturationDouble;
        return saturation;
    }

    public int getTotalExperience() {
        return this.playerFile.getInt("experience", 0);
    }

    public int getLevel() {
        return this.playerFile.getInt("level", 0);
    }

    public float getExperience() {
        double expDouble = this.playerFile.getDouble("exp", 0.0);
        float exp = (float)expDouble;
        return exp;
    }
}

