/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharable;

public final class SingleShareReader<T> {
    private final MultiverseInventories inventories;
    private final OfflinePlayer player;
    private final String worldName;
    private final ProfileType profileType;
    private final Sharable<T> sharable;

    public static <T> SingleShareReader<T> of(MultiverseInventories inventories, Player player, Sharable<T> sharable) {
        return new SingleShareReader<T>(inventories, (OfflinePlayer)player, player.getWorld().getName(), ProfileTypes.forPlayer(player), sharable);
    }

    public static <T> SingleShareReader<T> of(MultiverseInventories inventories, OfflinePlayer player, String worldName, ProfileType profileType, Sharable<T> sharable) {
        return new SingleShareReader<T>(inventories, player, worldName, profileType, sharable);
    }

    public SingleShareReader(MultiverseInventories inventories, OfflinePlayer player, String worldName, ProfileType profileType, Sharable<T> sharable) {
        this.inventories = inventories;
        this.player = player;
        this.worldName = worldName;
        this.profileType = profileType;
        this.sharable = sharable;
    }

    public CompletableFuture<T> read() {
        WorldGroupManager worldGroupManager = (WorldGroupManager)this.inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0]);
        List<WorldGroup> worldGroups = worldGroupManager.getGroupsForWorld(this.worldName);
        for (WorldGroup worldGroup : worldGroups) {
            if (!worldGroup.isSharing(this.sharable)) continue;
            return this.getSharableFromProfile(ContainerType.GROUP, worldGroup.getName());
        }
        return this.getSharableFromProfile(ContainerType.WORLD, this.worldName);
    }

    private CompletableFuture<T> getSharableFromProfile(ContainerType containerType, String containerName) {
        return ((ProfileContainerStoreProvider)this.inventories.getServiceLocator().getService(ProfileContainerStoreProvider.class, new Annotation[0])).getStore(containerType).getContainer(containerName).getPlayerData(this.profileType, this.player).thenApply(playerProfile -> playerProfile.get(this.sharable));
    }
}

