/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.util;

import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class MinecraftTools {
    private static final int TICKS_PER_SECOND = 20;

    public static long convertSecondsToTicks(long seconds) {
        return seconds * 20L;
    }

    public static ItemStack[] fillWithAir(ItemStack[] items) {
        for (int i = 0; i < items.length; ++i) {
            items[i] = new ItemStack(Material.AIR);
        }
        return items;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static Location findBedFromRespawnLocation(@Nullable Location respawnLocation) {
        if (respawnLocation == null) {
            return null;
        }
        Block bedSpawnBlock = respawnLocation.getBlock();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block newBedBlock = bedSpawnBlock.getRelative(x, y, z);
                    InvLogging.finest("Finding bed at: " + String.valueOf(newBedBlock), new Object[0]);
                    if (!(newBedBlock.getBlockData() instanceof Bed)) continue;
                    InvLogging.finer("Found bed!", new Object[0]);
                    return newBedBlock.getLocation();
                }
            }
        }
        InvLogging.warning("Unable to find bed, respawn may not work as expected!", new Object[0]);
        return respawnLocation;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static Location findAnchorFromRespawnLocation(@Nullable Location respawnLocation) {
        if (respawnLocation == null) {
            return null;
        }
        Block bedSpawnBlock = respawnLocation.getBlock();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block newBedBlock = bedSpawnBlock.getRelative(x, y, z);
                    InvLogging.finest("Finding anchor at: " + String.valueOf(newBedBlock), new Object[0]);
                    if (!(newBedBlock.getBlockData() instanceof RespawnAnchor)) continue;
                    InvLogging.finer("Found anchor!", new Object[0]);
                    return newBedBlock.getLocation();
                }
            }
        }
        InvLogging.warning("Unable to find anchor, respawn may not work as expected!", new Object[0]);
        return respawnLocation;
    }

    private MinecraftTools() {
        throw new IllegalStateException();
    }
}

