/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import dev.architectury.networking.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.satisfy.candlelight.client.gui.NoteGui;
import net.satisfy.candlelight.core.block.entity.TypewriterEntity;
import net.satisfy.candlelight.core.networking.packet.SyncTypewriterDataC2SPacket;
import net.satisfy.candlelight.core.registry.SoundEventRegistry;

@Environment(value=EnvType.CLIENT)
public class TypeWriterGui
extends NoteGui {
    private final TypewriterEntity typewriterEntity;
    private float lineProgressLocal = 0.0f;
    private static final int MAX_CHARS_PER_LINE = 19;
    private int charsInLine = 0;

    public TypeWriterGui(class_1657 player, TypewriterEntity typewriterEntity) {
        super(player, typewriterEntity.getPaper());
        this.typewriterEntity = typewriterEntity;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        assert (this.field_22787 != null);
        this.field_22787.field_1773.method_57796(delta);
        this.field_22787.method_1522().method_1235(false);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    public void method_52752(class_332 guiGraphics) {
    }

    protected void method_57734(float f) {
    }

    public void method_25432() {
        super.method_25432();
        this.typewriterEntity.snapRoller();
        this.typewriterEntity.setLineProgress(0.0f);
        this.charsInLine = 0;
        this.lineProgressLocal = 0.0f;
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        boolean result = super.method_25400(chr, modifiers);
        if (!result) {
            return false;
        }
        if (chr == '\n' || chr == '\r') {
            return true;
        }
        if (chr == ' ') {
            this.typewriterEntity.triggerSpace();
        } else {
            this.typewriterEntity.triggerKeyBounce();
        }
        ++this.charsInLine;
        if (this.charsInLine >= 19) {
            this.typewriterEntity.snapRoller();
            this.charsInLine = 0;
            this.lineProgressLocal = 0.0f;
            this.typewriterEntity.setLineProgress(0.0f);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14793, (float)1.0f));
            super.method_25400('\n', 0);
        } else {
            this.lineProgressLocal = (float)this.charsInLine / 19.0f;
            this.typewriterEntity.setLineProgress(this.lineProgressLocal);
        }
        this.playTypingSound();
        return true;
    }

    @Override
    protected void finalizeNote(boolean signNote) {
        if (this.dirty) {
            this.removeEmptyPages();
            this.writeNbtData(signNote);
        }
        class_2487 nbt = ((class_9279)this.itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        class_2338 pos = this.typewriterEntity.method_11016();
        NetworkManager.sendToServer((class_8710)new SyncTypewriterDataC2SPacket(nbt, pos, signNote));
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        if (!result) {
            return false;
        }
        if (keyCode == 257) {
            this.typewriterEntity.triggerEnter();
            this.typewriterEntity.snapRoller();
            this.charsInLine = 0;
            this.lineProgressLocal = 0.0f;
            this.typewriterEntity.setLineProgress(0.0f);
            this.playEnterSound();
            return true;
        }
        if (keyCode == 259) {
            if (this.charsInLine > 0) {
                --this.charsInLine;
                this.lineProgressLocal = (float)this.charsInLine / 19.0f;
                this.typewriterEntity.setLineProgress(this.lineProgressLocal);
            }
            this.playTypingSound();
            return true;
        }
        this.playTypingSound();
        return true;
    }

    private void playEnterSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14793, (float)1.0f));
    }

    private void playTypingSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)((class_3414)SoundEventRegistry.TYPEWRITER.get()), (float)2.0f));
    }
}

