/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.renderer.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.satisfy.candlelight.client.model.TypewriterModel;
import net.satisfy.candlelight.core.block.TypewriterBlock;
import net.satisfy.candlelight.core.block.entity.TypewriterEntity;
import net.satisfy.candlelight.core.registry.ObjectRegistry;

public class TypewriterRenderer
implements class_827<TypewriterEntity> {
    private static final class_2960 IRON_TEXTURE = class_2960.method_60655((String)"candlelight", (String)"textures/entity/typewriter_iron.png");
    private static final class_2960 GOLD_TEXTURE = class_2960.method_60655((String)"candlelight", (String)"textures/entity/typewriter_gold.png");
    private final class_630 typewriter;
    private final class_630 space;
    private final class_630 enter;
    private final class_630 roller;
    private final class_630 paper;
    private final class_630 paperWritten;
    private final List<class_630> keyParts;

    public TypewriterRenderer(class_5614.class_5615 context) {
        int i;
        class_630 pw;
        class_630 pp;
        class_630 rl;
        class_630 en;
        class_630 sp;
        class_630 root = context.method_32140(TypewriterModel.LAYER_LOCATION);
        this.typewriter = root.method_32086("typewriter");
        class_630 keyboard = this.typewriter.method_32086("keyboard");
        try {
            sp = keyboard.method_32086("space");
        }
        catch (Exception e) {
            sp = keyboard.method_32086("spacebar");
        }
        this.space = sp;
        try {
            en = keyboard.method_32086("enter");
        }
        catch (Exception e) {
            en = keyboard.method_32086("return");
        }
        this.enter = en;
        try {
            rl = this.typewriter.method_32086("roller");
        }
        catch (Exception e) {
            rl = this.typewriter.method_32086("carriage");
        }
        this.roller = rl;
        try {
            pp = this.typewriter.method_32086("paper");
        }
        catch (Exception e) {
            pp = this.typewriter.method_32086("sheet");
        }
        this.paper = pp;
        try {
            pw = this.typewriter.method_32086("paper_written");
        }
        catch (Exception e) {
            pw = this.typewriter.method_32086("sheet_written");
        }
        this.paperWritten = pw;
        ArrayList<class_630> keys = new ArrayList<class_630>();
        for (i = 1; i <= 7; ++i) {
            try {
                keys.add(keyboard.method_32086("button_" + i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (keys.isEmpty()) {
            for (i = 0; i < 8; ++i) {
                try {
                    keys.add(keyboard.method_32086("key" + i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.keyParts = keys;
    }

    public void render(TypewriterEntity be, float partialTicks, class_4587 poseStack, class_4597 buffers, int light, int overlay) {
        float ey;
        float prog;
        float offsetX;
        class_1937 level = be.method_10997();
        if (level == null) {
            return;
        }
        class_2680 state = level.method_8320(be.method_11016());
        if (!(state.method_26204() instanceof TypewriterBlock)) {
            return;
        }
        poseStack.method_22903();
        class_2350 facing = (class_2350)state.method_11654((class_2769)TypewriterBlock.FACING);
        float rotY = switch (facing) {
            case class_2350.field_11034 -> 270.0f;
            case class_2350.field_11035 -> 0.0f;
            case class_2350.field_11039 -> 90.0f;
            default -> 180.0f;
        };
        float offsetZ = switch (facing) {
            case class_2350.field_11035 -> {
                offsetX = 0.5f;
                yield -0.5f;
            }
            case class_2350.field_11034 -> {
                offsetX = -0.5f;
                yield -0.5f;
            }
            case class_2350.field_11039 -> {
                offsetX = 0.5f;
                yield 0.5f;
            }
            default -> {
                offsetX = -0.5f;
                yield 0.5f;
            }
        };
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotY));
        poseStack.method_46416(offsetX, -1.5f, offsetZ);
        class_4588 vc = buffers.getBuffer(class_1921.method_23578((class_2960)this.getTexture(state)));
        float f = prog = be.getRollerSnapTicks() > 0 ? 0.0f : be.getLineProgress();
        if (prog < 0.0f) {
            prog = 0.0f;
        }
        if (prog > 1.0f) {
            prog = 1.0f;
        }
        float rx = 0.15f + prog * 4.5f;
        float sy = be.getSpaceTicks() > 0 ? 0.5f : 0.0f;
        float f2 = ey = be.getEnterTicks() > 0 ? 0.5f : 0.0f;
        if (this.space != null) {
            this.space.field_3656 += sy;
        }
        if (this.enter != null) {
            this.enter.field_3656 += ey;
        }
        int idx = be.getBouncingKeyIndex();
        boolean bounced = false;
        if (be.getKeyBounceTicks() > 0 && be.getSpaceTicks() == 0 && be.getEnterTicks() == 0 && !this.keyParts.isEmpty()) {
            if (idx < 0 || idx >= this.keyParts.size()) {
                be.setBouncingKeyIndex(level.field_9229.method_43048(this.keyParts.size()));
                idx = be.getBouncingKeyIndex();
            }
            this.keyParts.get((int)idx).field_3656 += 0.5f;
            bounced = true;
        }
        if (this.roller != null) {
            this.roller.field_3657 += rx;
        }
        int full = (Integer)state.method_11654((class_2769)TypewriterBlock.FULL);
        if (this.paper != null) {
            this.paper.field_3665 = false;
        }
        if (this.paperWritten != null) {
            this.paperWritten.field_3665 = false;
        }
        if (full == 1 && this.paper != null) {
            this.paper.field_3665 = true;
        } else if (full == 2 && this.paperWritten != null) {
            this.paperWritten.field_3665 = true;
        }
        this.typewriter.method_22698(poseStack, vc, light, overlay);
        if (this.space != null) {
            this.space.field_3656 -= sy;
        }
        if (this.enter != null) {
            this.enter.field_3656 -= ey;
        }
        if (bounced && idx < this.keyParts.size()) {
            this.keyParts.get((int)idx).field_3656 -= 0.5f;
        }
        if (this.roller != null) {
            this.roller.field_3657 -= rx;
        }
        if (level.method_8608()) {
            be.tickAnimations();
        }
        poseStack.method_22909();
    }

    private class_2960 getTexture(class_2680 state) {
        if (state.method_27852((class_2248)ObjectRegistry.TYPEWRITER_IRON.get())) {
            return IRON_TEXTURE;
        }
        if (state.method_27852((class_2248)ObjectRegistry.TYPEWRITER_GOLD.get())) {
            return GOLD_TEXTURE;
        }
        return IRON_TEXTURE;
    }
}

