/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.satisfy.candlelight.core.block.CookingPanBlock;
import net.satisfy.candlelight.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.client.gui.handler.RoasterGuiHandler;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.core.recipe.RecipeUnlockManager;
import net.satisfy.farm_and_charm.core.recipe.RoasterRecipe;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.TagRegistry;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingPanBlockEntity
extends class_2586
implements class_5558<CookingPanBlockEntity>,
ImplementedInventory,
class_3908 {
    private static final int FIRST_INGREDIENT_SLOT = 0;
    private static final int LAST_INGREDIENT_SLOT = 5;
    private static final int CONTAINER_SLOT = 6;
    private static final int OUTPUT_SLOT = 7;
    private static final int MAX_CAPACITY = 8;
    private static final int MAX_ROASTING_TIME = 900;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private int roastingTime;
    private boolean isBeingBurned;
    private UUID ownerUuid;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CookingPanBlockEntity.this.roastingTime;
                case 1 -> {
                    if (CookingPanBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CookingPanBlockEntity.this.roastingTime = value;
                    break;
                }
                case 1: {
                    CookingPanBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public CookingPanBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.COOKING_PAN_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] method_5494(class_2350 side) {
        int[] nArray;
        switch (side) {
            case field_11036: {
                int[] nArray2 = new int[6];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray = nArray2;
                nArray2[5] = 5;
                break;
            }
            case field_11033: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 7;
                break;
            }
            default: {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 6;
            }
        }
        return nArray;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        class_2371 loaded = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, (class_2371)loaded, (class_7225.class_7874)provider);
        for (int i = 0; i < 8; ++i) {
            this.inventory.set(i, (Object)((class_1799)loaded.get(i)));
        }
        this.roastingTime = tag.method_10550("RoastingTime");
        if (tag.method_25928("OwnerUUID")) {
            this.ownerUuid = tag.method_25926("OwnerUUID");
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)provider);
        tag.method_10569("RoastingTime", this.roastingTime);
        if (this.ownerUuid != null) {
            tag.method_25927("OwnerUUID", this.ownerUuid);
        }
    }

    public boolean isBeingBurned() {
        if (this.field_11863 == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        class_2680 belowState = this.field_11863.method_8320(this.field_11867.method_10074());
        return belowState.method_26164(TagRegistry.ALLOWS_COOKING);
    }

    private boolean canCraft(class_1860<?> recipe, class_5455 access) {
        if (recipe == null || recipe.method_8110((class_7225.class_7874)access).method_7960()) {
            return false;
        }
        if (recipe instanceof RoasterRecipe) {
            RoasterRecipe roastingRecipe = (RoasterRecipe)recipe;
            class_1799 containerSlotStack = this.method_5438(6);
            if (!containerSlotStack.method_31574(roastingRecipe.getContainer().method_7909())) {
                return false;
            }
            class_1799 outputSlotStack = this.method_5438(7);
            class_1799 expected = this.generateOutputItem(recipe, access);
            return outputSlotStack.method_7960() || class_1799.method_31577((class_1799)outputSlotStack, (class_1799)expected) && outputSlotStack.method_7947() < outputSlotStack.method_7914();
        }
        return false;
    }

    private void craft(class_1860<?> recipe, class_5455 access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = this.generateOutputItem(recipe, access);
        class_1799 outputSlotStack = this.method_5438(7);
        if (outputSlotStack.method_7960()) {
            this.method_5447(7, recipeOutput);
        } else {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        recipe.method_8117().forEach(ingredient -> {
            for (int slot = 0; slot <= 5; ++slot) {
                class_1799 stack = this.method_5438(slot);
                if (!ingredient.method_8093(stack)) continue;
                class_1799 remainderStack = stack.method_7909().method_7857() ? new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858())) : class_1799.field_8037;
                stack.method_7934(1);
                if (remainderStack.method_7960()) break;
                this.method_5447(slot, remainderStack);
                break;
            }
        });
        class_1799 containerSlotStack = this.method_5438(6);
        if (!containerSlotStack.method_7960()) {
            containerSlotStack.method_7934(1);
            if (containerSlotStack.method_7960()) {
                this.method_5447(6, class_1799.field_8037);
            }
        }
        this.method_5431();
    }

    private class_1799 generateOutputItem(class_1860<?> recipe, class_5455 access) {
        class_1799 outputStack = recipe.method_8110((class_7225.class_7874)access).method_7972();
        if (outputStack.method_7909() instanceof EffectFood) {
            for (class_1293 inst : EffectFoodHelper.collectMergedSortedEffects((class_1263)this, (int)0, (int)5)) {
                EffectFoodHelper.addEffect((class_1799)outputStack, (Pair)new Pair((Object)inst, (Object)Float.valueOf(1.0f)));
            }
        }
        return outputStack;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CookingPanBlockEntity blockEntity) {
        class_3222 owner;
        RoasterRecipe roastingRecipe;
        RoasterRecipe roasterRecipe;
        if (world.method_8608()) {
            return;
        }
        boolean wasBeingBurned = this.isBeingBurned;
        this.isBeingBurned = this.isBeingBurned();
        if (wasBeingBurned != this.isBeingBurned || (Boolean)state.method_11654((class_2769)CookingPanBlock.LIT) != this.isBeingBurned) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPanBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
        if (!this.isBeingBurned) {
            return;
        }
        if (this.field_11863 == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        class_1863 recipeManager = this.field_11863.method_8433();
        List recipes = recipeManager.method_30027((class_3956)RecipeTypeRegistry.ROASTER_RECIPE_TYPE.get());
        Optional<RoasterRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        class_5455 access = this.field_11863.method_30349();
        if (recipe.isPresent() && (roasterRecipe = recipe.get()) instanceof RoasterRecipe && (roastingRecipe = roasterRecipe).requiresLearning() && ((owner = Objects.requireNonNull(world.method_8503()).method_3760().method_14602(this.ownerUuid)) == null || RecipeUnlockManager.isRecipeLocked((class_3222)owner, (class_2960)class_7923.field_41188.method_10221((Object)recipe.get().method_17716())))) {
            this.roastingTime = 0;
            if (((Boolean)state.method_11654((class_2769)CookingPanBlock.COOKING)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPanBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        if (recipe.isPresent() && this.canCraft((class_1860)recipe.get(), access)) {
            if (++this.roastingTime >= 900) {
                this.roastingTime = 0;
                this.craft((class_1860)recipe.get(), access);
            }
            if (!((Boolean)state.method_11654((class_2769)CookingPanBlock.COOKING)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPanBlock.COOKING, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            this.roastingTime = 0;
            if (((Boolean)state.method_11654((class_2769)CookingPanBlock.COOKING)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPanBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new RoasterGuiHandler(syncId, inv, (class_1263)this, this.delegate);
    }

    private RoasterRecipe getRecipe(List<class_8786<RoasterRecipe>> recipes, class_2371<class_1799> inventory) {
        for (class_8786<RoasterRecipe> recipeHolder : recipes) {
            RoasterRecipe recipe = (RoasterRecipe)recipeHolder.comp_1933();
            if (!this.matchesInventory(recipe, inventory)) continue;
            return recipe;
        }
        return null;
    }

    private boolean matchesInventory(RoasterRecipe recipe, class_2371<class_1799> inventory) {
        class_2371 ingredients = recipe.method_8117();
        class_2371 invCopy = class_2371.method_10213((int)inventory.size(), (Object)class_1799.field_8037);
        for (int i = 0; i <= 5; ++i) {
            invCopy.set(i, (Object)((class_1799)inventory.get(i)).method_7972());
        }
        for (class_1856 ingredient : ingredients) {
            boolean matched = false;
            for (int i = 0; i <= 5; ++i) {
                class_1799 stack = (class_1799)invCopy.get(i);
                if (stack.method_7960() || !ingredient.method_8093(stack)) continue;
                stack.method_7934(1);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        block3: for (int i = 0; i <= 5; ++i) {
            class_1799 remaining = (class_1799)invCopy.get(i);
            if (remaining.method_7960()) continue;
            for (class_1856 ingredient : ingredients) {
                if (!ingredient.method_8093(remaining)) continue;
                continue block3;
            }
            return false;
        }
        return true;
    }
}

