/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.block.StorageBlock;
import net.satisfy.candlelight.core.registry.StorageTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.625, (double)1.0, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.9375, (double)1.0, (double)0.1875, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public ShelfBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction side = ctx.getClickedFace();
        BlockState blockState = side != Direction.DOWN && side != Direction.UP ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getClickedFace()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
        if (blockState.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) {
            return blockState;
        }
        return null;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        if (!(stack.getItem() instanceof BlockItem)) {
            stack.getItem();
        }
        return true;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @Override
    public int size() {
        return 9;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.SHELF;
    }

    @Override
    public int getSection(Float f, Float y) {
        float oneS = 0.11111111f;
        int nSection = (int)(f.floatValue() / oneS);
        return 8 - nSection;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape;
        return Block.isFaceFull((VoxelShape)shape, (Direction)(switch (((Direction)state.getValue((Property)FACING)).getOpposite()) {
            case Direction.EAST -> {
                shape = world.getBlockState(pos.east()).getShape((BlockGetter)world, pos.east());
                yield Direction.WEST;
            }
            case Direction.SOUTH -> {
                shape = world.getBlockState(pos.south()).getShape((BlockGetter)world, pos.south());
                yield Direction.NORTH;
            }
            case Direction.WEST -> {
                shape = world.getBlockState(pos.west()).getShape((BlockGetter)world, pos.west());
                yield Direction.EAST;
            }
            default -> {
                shape = world.getBlockState(pos.north()).getShape((BlockGetter)world, pos.north());
                yield Direction.SOUTH;
            }
        }));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }
}

