/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.LineConnectingBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class SofaBlock
extends LineConnectingBlock {
    public static final Map<Direction, VoxelShape> SHAPE;
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_SHAPE;
    private static final Supplier<VoxelShape> noneShapeSupplier;
    private static final Supplier<VoxelShape> middleShapeSupplier;
    private static final Supplier<VoxelShape> leftShapeSupplier;
    private static final Supplier<VoxelShape> rightShapeSupplier;

    public SofaBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (switch ((GeneralUtil.LineConnectingType)state.getValue((Property)TYPE)) {
            case GeneralUtil.LineConnectingType.MIDDLE -> MIDDLE_SHAPE;
            case GeneralUtil.LineConnectingType.LEFT -> LEFT_SHAPE;
            case GeneralUtil.LineConnectingType.RIGHT -> RIGHT_SHAPE;
            default -> SHAPE;
        }).get(state.getValue((Property)FACING));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hit) {
        return GeneralUtil.onUse((Level)world, (Player)player, (InteractionHand)hand, (BlockHitResult)hit, (double)0.2);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        GeneralUtil.onStateReplaced((Level)world, (BlockPos)pos);
    }

    static {
        noneShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.0, (double)0.9375, (double)0.4375, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.125, (double)0.875, (double)0.1875, (double)0.3125));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.875, (double)0.1875, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.3125, (double)0.1875, (double)0.3125));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.6875, (double)0.3125, (double)0.1875, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875625, (double)0.0625, (double)0.125, (double)0.8125625, (double)0.9375));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.1875625, (double)0.0625, (double)1.0, (double)0.8125625, (double)0.9375));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.4375, (double)0.875, (double)0.9375, (double)1.0, (double)1.0));
            return shape;
        };
        middleShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.0, (double)1.0, (double)0.4375, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.4375, (double)0.875, (double)1.0, (double)1.0, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.0, (double)0.0625, (double)0.4375, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.4375, (double)0.875, (double)0.0625, (double)1.0, (double)1.0));
            return shape;
        };
        leftShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.0, (double)1.0, (double)0.4375, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.3125, (double)0.1875, (double)0.3125));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.6875, (double)0.3125, (double)0.1875, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875625, (double)0.0625, (double)0.125, (double)0.8125625, (double)0.9375));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.4375, (double)0.875, (double)1.0, (double)1.0, (double)1.0));
            return shape;
        };
        rightShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.0, (double)0.9375, (double)0.4375, (double)1.0));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.125, (double)0.875, (double)0.1875, (double)0.3125));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.6875, (double)0.875, (double)0.1875, (double)0.875));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.1875625, (double)0.0625, (double)1.0, (double)0.8125625, (double)0.9375));
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.4375, (double)0.875, (double)0.9375, (double)1.0, (double)1.0));
            return shape;
        };
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)noneShapeSupplier.get()));
            }
        });
        MIDDLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)middleShapeSupplier.get()));
            }
        });
        LEFT_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)leftShapeSupplier.get()));
            }
        });
        RIGHT_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)rightShapeSupplier.get()));
            }
        });
    }
}

