/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.satisfy.candlelight.core.util.CandlelightUtil;
import org.jetbrains.annotations.NotNull;

public class WrittenPaperItem
extends Item {
    public WrittenPaperItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (world.isClientSide()) {
            CandlelightUtil.setSignedPaperScreen(itemStack);
        } else {
            user.containerMenu.broadcastChanges();
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @NotNull
    public Component getName(ItemStack stack) {
        String string;
        CompoundTag nbtCompound = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbtCompound != null && !StringUtil.isNullOrEmpty((String)(string = nbtCompound.getString("title")))) {
            return Component.literal((String)string);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag nbtCompound = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            assert (nbtCompound != null);
            String string = nbtCompound.getString("author");
            if (!StringUtil.isNullOrEmpty((String)string)) {
                tooltip.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{string}).withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

