/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.part;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.part.PartTypeInterfaceCraftingBase;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCrafting;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integratedcrafting.part.PartTypes;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;

public class PartTypeInterfaceCrafting
extends PartTypeInterfaceCraftingBase<PartTypeInterfaceCrafting, State> {
    public PartTypeInterfaceCrafting(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return state.getCraftingJobHandler().getProcessingCraftingJobs().size() * GeneralConfig.interfaceCraftingBaseConsumption;
    }

    @Override
    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public MutableComponent getDisplayName() {
                return Component.translatable((String)PartTypeInterfaceCrafting.this.getTranslationKey());
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                State partState = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                return new ContainerPartInterfaceCrafting(id, playerInventory, (Container)partState.getInventoryVariables(), Optional.of((PartTarget)data.getRight()), Optional.of((IPartContainer)data.getLeft()), (PartTypeInterfaceCrafting)((Object)data.getMiddle()));
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        });
    }

    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked((PartPos)pos);
        State partState = (State)partContainer.getPartState(pos.getSide());
        packetBuffer.writeInt(partState.getInventoryVariables().getContainerSize());
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    public Optional<MenuProvider> getContainerProviderSettings(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public MutableComponent getDisplayName() {
                return Component.translatable((String)PartTypeInterfaceCrafting.this.getTranslationKey());
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerPartInterfaceCraftingSettings(id, playerInventory, (Container)new SimpleContainer(0), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (IPartType)data.getMiddle());
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        });
    }

    protected State constructDefaultState() {
        return new State();
    }

    @Override
    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        ICraftingNetwork craftingNetwork;
        super.update(network, partNetwork, target, state);
        IntSet slots = state.getDelayedRecipeReloads();
        if (!slots.isEmpty() && (craftingNetwork = (ICraftingNetwork)network.getCapability(this.getNetworkCapability()).orElse(null)) != null) {
            IntOpenHashSet slotsCopy = new IntOpenHashSet((IntCollection)slots);
            slots.clear();
            int channel = state.getChannelCrafting();
            for (Integer slot : slotsCopy) {
                Int2ObjectMap<IRecipeDefinition> recipes = state.getRecipesIndexed();
                IRecipeDefinition oldRecipe = (IRecipeDefinition)recipes.get((Object)slot);
                if (oldRecipe != null) {
                    craftingNetwork.removeCraftingInterfaceRecipe(channel, state, oldRecipe);
                }
                state.reloadRecipe(slot, state.ticksAfterReload <= 1);
                IRecipeDefinition newRecipe = (IRecipeDefinition)recipes.get((Object)slot);
                if (newRecipe == null) continue;
                craftingNetwork.addCraftingInterfaceRecipe(channel, state, newRecipe);
            }
        }
        ++state.ticksAfterReload;
    }

    @Override
    public void addDrops(PartTarget target, State state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (int i = 0; i < state.getInventoryVariables().getContainerSize(); ++i) {
            ItemStack itemStack = state.getInventoryVariables().getItem(i);
            if (itemStack.isEmpty()) continue;
            itemStacks.add(itemStack);
        }
        state.getInventoryVariables().clearContent();
        super.addDrops(target, state, itemStacks, dropMainElement, saveState);
    }

    public static class State
    extends PartTypeInterfaceCraftingBase.State<PartTypeInterfaceCrafting, State> {
        protected int ticksAfterReload = 0;
        private final SimpleInventory inventoryVariables = new SimpleInventory(9, 1);
        private final List<InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe>> variableEvaluators;
        private final Int2ObjectMap<Component> recipeSlotMessages;
        private final Int2BooleanMap recipeSlotValidated;
        private final IntSet delayedRecipeReloads;
        private final Map<IVariable, Boolean> variableListeners;
        private boolean disableCraftingCheck = false;
        private final Int2ObjectMap<IRecipeDefinition> currentRecipes;

        public State() {
            this.inventoryVariables.addDirtyMarkListener((IDirtyMarkListener)this);
            this.variableEvaluators = Lists.newArrayList();
            this.recipeSlotMessages = new Int2ObjectArrayMap();
            this.recipeSlotValidated = new Int2BooleanArrayMap();
            this.delayedRecipeReloads = new IntArraySet();
            this.variableListeners = new MapMaker().weakKeys().makeMap();
            this.currentRecipes = new Int2ObjectArrayMap();
        }

        public SimpleInventory getInventoryVariables() {
            return this.inventoryVariables;
        }

        @Override
        public void serialize(ValueOutput valueOutput) {
            super.serialize(valueOutput);
            this.inventoryVariables.writeToNBT(valueOutput, "variables");
            ValueOutput.ValueOutputList recipeSlotErrorsTag = valueOutput.childrenList("recipeSlotMessages");
            for (Int2ObjectMap.Entry entry : this.recipeSlotMessages.int2ObjectEntrySet()) {
                ValueOutput child = recipeSlotErrorsTag.addChild();
                child.putInt("key", entry.getIntKey());
                NBTClassType.writeNbt(Component.class, (String)"value", (Object)((Component)entry.getValue()), (ValueOutput)child);
            }
            ValueOutput.ValueOutputList recipeSlotValidatedTag = valueOutput.childrenList("recipeSlotValidated");
            for (Int2BooleanMap.Entry entry : this.recipeSlotValidated.int2BooleanEntrySet()) {
                ValueOutput entryTag = recipeSlotValidatedTag.addChild();
                entryTag.putInt("key", entry.getIntKey());
                entryTag.putBoolean("value", entry.getBooleanValue());
            }
            valueOutput.putBoolean("disableCraftingCheck", this.disableCraftingCheck);
        }

        @Override
        public void deserialize(ValueInput valueInput) {
            super.deserialize(valueInput);
            this.inventoryVariables.readFromNBT(valueInput, "variables");
            this.recipeSlotMessages.clear();
            for (ValueInput slot : (ValueInput.ValueInputList)valueInput.childrenList("recipeSlotMessages").orElseThrow()) {
                Component unlocalizedString = (Component)NBTClassType.readNbt(Component.class, (String)"value", (ValueInput)slot);
                this.recipeSlotMessages.put((Integer)slot.getInt("key").orElseThrow(), (Object)unlocalizedString);
            }
            this.recipeSlotValidated.clear();
            for (ValueInput slot : (ValueInput.ValueInputList)valueInput.childrenList("recipeSlotValidated").orElseThrow()) {
                this.recipeSlotValidated.put(((Integer)slot.getInt("key").orElseThrow()).intValue(), slot.getBooleanOr("value", false));
            }
            this.disableCraftingCheck = valueInput.getBooleanOr("disableCraftingCheck", false);
        }

        @Override
        public void reloadRecipes(boolean initialize) {
            this.currentRecipes.clear();
            this.recipeSlotMessages.clear();
            this.recipeSlotValidated.clear();
            this.variableEvaluators.clear();
            int i = 0;
            while (i < this.getInventoryVariables().getContainerSize()) {
                final int slot = i++;
                this.variableEvaluators.add(new InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe>((Container)this.getInventoryVariables(), slot, this.valueDeseralizationContext, (IValueType)ValueTypes.OBJECT_RECIPE){

                    public void onErrorsChanged() {
                        super.onErrorsChanged();
                        this.setLocalErrors(slot, this.getErrors());
                    }
                });
            }
            if (this.partNetwork != null) {
                for (i = 0; i < this.getInventoryVariables().getContainerSize(); ++i) {
                    this.reloadRecipe(i, initialize);
                }
            }
        }

        private void setLocalErrors(int slot, List<MutableComponent> errors) {
            if (errors.isEmpty()) {
                if (this.recipeSlotMessages.size() > slot) {
                    this.recipeSlotMessages.remove(slot);
                }
            } else {
                this.recipeSlotMessages.put(slot, (Object)((Component)errors.get(0)));
            }
        }

        protected void reloadRecipe(int slot, boolean initialize) {
            this.currentRecipes.remove(slot);
            if (this.recipeSlotMessages.size() > slot) {
                this.recipeSlotMessages.remove(slot);
            }
            if (this.recipeSlotValidated.size() > slot) {
                this.recipeSlotValidated.remove(slot);
            }
            if (this.partNetwork != null) {
                IVariable variable;
                block16: {
                    InventoryVariableEvaluator<ValueObjectTypeRecipe.ValueRecipe> evaluator = this.variableEvaluators.get(slot);
                    evaluator.refreshVariable(this.network, false);
                    variable = evaluator.getVariable(this.network);
                    if (variable != null) {
                        try {
                            IValue value;
                            if (!this.variableListeners.containsKey(variable)) {
                                variable.addInvalidationListener(() -> {
                                    this.variableListeners.remove(variable);
                                    this.delayedReloadRecipe(slot);
                                });
                                this.variableListeners.put(variable, true);
                            }
                            if ((value = variable.getValue()).getType() == ValueTypes.OBJECT_RECIPE) {
                                Optional recipeWrapper = ((ValueObjectTypeRecipe.ValueRecipe)value).getRawValue();
                                if (recipeWrapper.isPresent()) {
                                    IRecipeDefinition recipe = (IRecipeDefinition)recipeWrapper.get();
                                    if (!GeneralConfig.validateRecipesCraftingInterface || this.disableCraftingCheck || this.isValid(recipe)) {
                                        this.currentRecipes.put(slot, (Object)recipe);
                                        this.recipeSlotValidated.put(slot, true);
                                        this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.valid"));
                                    } else {
                                        this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.invalid"));
                                    }
                                }
                                break block16;
                            }
                            this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.norecipe"));
                        }
                        catch (EvaluationException e) {
                            this.recipeSlotMessages.put(slot, (Object)e.getErrorMessage());
                        }
                    } else if (initialize && evaluator.hasVariable()) {
                        this.delayedReloadRecipe(slot);
                    } else {
                        this.recipeSlotMessages.put(slot, (Object)Component.translatable((String)"gui.integratedcrafting.partinterface.slot.message.norecipe"));
                    }
                }
                try {
                    IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked((INetwork)this.network);
                    NeoForge.EVENT_BUS.post((Event)new PartVariableDrivenVariableContentsUpdatedEvent(this.network, partNetwork, this.getTarget(), (IPartType)PartTypes.INTERFACE_CRAFTING, (IPartState)this, this.lastPlayer, variable, variable != null ? variable.getValue() : null));
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
            }
            this.sendUpdate();
        }

        private void delayedReloadRecipe(int slot) {
            this.delayedRecipeReloads.add(slot);
        }

        private boolean isValid(IRecipeDefinition recipe) {
            DimPos dimPos = this.getTarget().getTarget().getPos();
            Direction side = this.getTarget().getTarget().getSide();
            IRecipeHandler recipeHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)dimPos.getLevel(true), dimPos.getBlockPos(), (Object)side, Capabilities.RecipeHandler.BLOCK).orElse(null);
            if (recipeHandler != null) {
                IMixedIngredients simulatedOutput = recipeHandler.simulate(recipe);
                if (simulatedOutput != null && !simulatedOutput.isEmpty()) {
                    if (recipe.getOutput().containsAll(simulatedOutput)) {
                        return true;
                    }
                    if (GeneralConfig.logRecipeValidationFailures) {
                        IntegratedCrafting.clog(Level.INFO, "Recipe validation failure: incompatible recipe output and simulated output:\nRecipe output: " + String.valueOf(recipe.getOutput()) + "\nSimulated output: " + String.valueOf(simulatedOutput));
                    }
                    return false;
                }
                if (GeneralConfig.logRecipeValidationFailures) {
                    IntegratedCrafting.clog(Level.INFO, "Recipe validation failure: No output was obtained when simulating a recipe\n" + String.valueOf(recipe));
                }
                return false;
            }
            return true;
        }

        public void onDirty() {
            super.onDirty();
            if (this.craftingNetwork != null) {
                this.craftingNetwork.removeCraftingInterface(this.getChannelCrafting(), this);
            }
            if (this.getTarget() != null && !this.getTarget().getCenter().getPos().getLevel((boolean)true).isClientSide) {
                this.reloadRecipes(false);
            }
            if (this.craftingNetwork != null) {
                this.craftingNetwork.addCraftingInterface(this.getChannelCrafting(), this);
            }
        }

        @Override
        public Collection<IRecipeDefinition> getRecipes() {
            return this.currentRecipes.values();
        }

        public Int2ObjectMap<IRecipeDefinition> getRecipesIndexed() {
            return this.currentRecipes;
        }

        public boolean isRecipeSlotValid(int slot) {
            return this.recipeSlotValidated.containsKey(slot);
        }

        @Nullable
        public Component getRecipeSlotUnlocalizedMessage(int slot) {
            return (Component)this.recipeSlotMessages.get(slot);
        }

        public IntSet getDelayedRecipeReloads() {
            return this.delayedRecipeReloads;
        }

        public void setDisableCraftingCheck(boolean disableCraftingCheck) {
            if (disableCraftingCheck != this.disableCraftingCheck) {
                this.disableCraftingCheck = disableCraftingCheck;
                this.sendUpdate();
            }
        }

        public boolean isDisableCraftingCheck() {
            return this.disableCraftingCheck;
        }
    }
}

