/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageCollectionWrapper;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingJobHandler;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;

public class PendingCraftingJobResultIndexObserver<T, M>
implements IIngredientComponentStorageObservable.IIndexChangeObserver<T, M> {
    private final IngredientComponent<T, M> ingredientComponent;
    private final CraftingJobHandler handler;
    private final ICraftingNetwork craftingNetwork;

    public PendingCraftingJobResultIndexObserver(IngredientComponent<T, M> ingredientComponent, CraftingJobHandler handler, ICraftingNetwork craftingNetwork) {
        this.ingredientComponent = ingredientComponent;
        this.handler = handler;
        this.craftingNetwork = craftingNetwork;
    }

    public void onChange(IIngredientComponentStorageObservable.StorageChangeEvent<T, M> event) {
        if (event.getChangeType() == IIngredientComponentStorageObservable.Change.ADDITION && !event.isInitialChange()) {
            IIngredientCollection addedIngredients = event.getInstances();
            IngredientComponentStorageCollectionWrapper ingredientsHayStack = null;
            IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
            Int2ObjectMap<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> processingJobs = this.handler.getProcessingCraftingJobsPendingIngredients();
            ObjectIterator jobsEntryIt = processingJobs.int2ObjectEntrySet().iterator();
            while (jobsEntryIt.hasNext()) {
                Int2ObjectMap.Entry jobsEntry = (Int2ObjectMap.Entry)jobsEntryIt.next();
                int craftingJobId = jobsEntry.getIntKey();
                CraftingJob craftingJob = (CraftingJob)this.handler.getAllCraftingJobs().get(jobsEntry.getIntKey());
                if (craftingJob == null || craftingJob.getChannel() != -1 && craftingJob.getChannel() != event.getChannel()) continue;
                Iterator jobEntryIt = ((List)jobsEntry.getValue()).iterator();
                while (jobEntryIt.hasNext()) {
                    Map jobEntry = (Map)jobEntryIt.next();
                    List pendingIngredientsUnsafe = (List)jobEntry.get(this.ingredientComponent);
                    if (pendingIngredientsUnsafe == null) continue;
                    List pendingIngredients = pendingIngredientsUnsafe;
                    ListIterator<PrototypedIngredient> it = pendingIngredients.listIterator();
                    while (it.hasNext()) {
                        Object extracted;
                        long initialQuantity;
                        IPrototypedIngredient prototypedIngredient = (IPrototypedIngredient)it.next();
                        long remainingQuantity = initialQuantity = matcher.getQuantity(prototypedIngredient.getPrototype());
                        if (ingredientsHayStack == null) {
                            if (!addedIngredients.contains(prototypedIngredient.getPrototype(), prototypedIngredient.getCondition())) continue;
                            IngredientCollectionPrototypeMap prototypeMap = new IngredientCollectionPrototypeMap(this.ingredientComponent);
                            ingredientsHayStack = new IngredientComponentStorageCollectionWrapper((IIngredientCollapsedCollectionMutable)prototypeMap);
                            prototypeMap.addAll((Iterable)addedIngredients);
                        }
                        while (!matcher.isEmpty(extracted = ingredientsHayStack.extract(prototypedIngredient.getPrototype(), prototypedIngredient.getCondition(), false)) && !matcher.isEmpty(extracted) && (remainingQuantity -= matcher.getQuantity(extracted)) > 0L) {
                        }
                        if (remainingQuantity <= 0L) {
                            it.remove();
                            continue;
                        }
                        if (initialQuantity == remainingQuantity) continue;
                        it.set(new PrototypedIngredient(this.ingredientComponent, matcher.withQuantity(prototypedIngredient.getPrototype(), remainingQuantity), prototypedIngredient.getCondition()));
                    }
                    if (!pendingIngredients.isEmpty()) continue;
                    this.handler.getObserversPendingDeletion().add(this.ingredientComponent);
                    jobEntry.remove(this.ingredientComponent);
                    if (jobEntry.isEmpty()) {
                        this.handler.onCraftingJobEntryFinished(this.craftingNetwork, craftingJobId);
                        jobEntryIt.remove();
                    }
                    if (!((List)jobsEntry.getValue()).isEmpty()) continue;
                    this.handler.onCraftingJobFinished((CraftingJob)this.handler.getAllCraftingJobs().get(craftingJobId));
                    this.handler.getProcessingCraftingJobsRaw().remove(craftingJobId);
                    jobsEntryIt.remove();
                }
            }
        }
    }
}

