/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.MissingIngredients;
import org.cyclops.integratedcrafting.core.PendingCraftingJobResultIndexObserver;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingJobHandler {
    private final int maxProcessingJobs;
    private boolean blockingJobsMode;
    private final ICraftingResultsSink resultsSink;
    private final Collection<ICraftingProcessOverride> craftingProcessOverrides;
    private final Int2ObjectMap<CraftingJob> allCraftingJobs;
    private final Int2ObjectMap<CraftingJob> processingCraftingJobs;
    private final Int2ObjectMap<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> processingCraftingJobsPendingIngredients;
    private final Int2ObjectMap<CraftingJob> pendingCraftingJobs;
    private final Object2IntMap<IngredientComponent<?, ?>> ingredientObserverCounters;
    private final Map<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> ingredientObservers;
    private final List<IngredientComponent<?, ?>> observersPendingCreation;
    private final List<IngredientComponent<?, ?>> observersPendingDeletion;
    private final Int2ObjectMap<CraftingJob> finishedCraftingJobs;
    private final Map<IngredientComponent<?, ?>, Direction> ingredientComponentTargetOverrides;
    private final Int2IntMap nonBlockingJobsRunningAmount;

    public CraftingJobHandler(int maxProcessingJobs, boolean blockingJobsMode, Collection<ICraftingProcessOverride> craftingProcessOverrides, ICraftingResultsSink resultsSink) {
        this.maxProcessingJobs = maxProcessingJobs;
        this.blockingJobsMode = blockingJobsMode;
        this.resultsSink = resultsSink;
        this.craftingProcessOverrides = craftingProcessOverrides;
        this.allCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobs = new Int2ObjectOpenHashMap();
        this.pendingCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobsPendingIngredients = new Int2ObjectOpenHashMap();
        this.ingredientObserverCounters = new Object2IntOpenHashMap();
        this.ingredientObservers = Maps.newIdentityHashMap();
        this.observersPendingCreation = Lists.newArrayList();
        this.observersPendingDeletion = Lists.newArrayList();
        this.finishedCraftingJobs = new Int2ObjectOpenHashMap();
        this.ingredientComponentTargetOverrides = Maps.newIdentityHashMap();
        this.nonBlockingJobsRunningAmount = new Int2IntOpenHashMap();
    }

    public void serialize(ValueOutput valueOutput) {
        valueOutput.putBoolean("blockingJobsMode", this.blockingJobsMode);
        ValueOutput.ValueOutputList processingCraftingJobs = valueOutput.childrenList("processingCraftingJobs");
        for (CraftingJob processingCraftingJob : this.processingCraftingJobs.values()) {
            ValueOutput entriesTag = processingCraftingJobs.addChild();
            CraftingJob.serialize(entriesTag.child("craftingJob"), processingCraftingJob);
            List list = (List)this.processingCraftingJobsPendingIngredients.get(processingCraftingJob.getId());
            ValueOutput.ValueOutputList pendingEntries = entriesTag.childrenList("pendingIngredientInstanceEntries");
            for (Map ingredients : list) {
                ValueOutput pendingEntryTag = pendingEntries.addChild();
                ValueOutput.ValueOutputList pendingIngredientInstances = pendingEntryTag.childrenList("v");
                for (Map.Entry ingredientComponentListEntry : ingredients.entrySet()) {
                    ValueOutput ingredientInstance = pendingIngredientInstances.addChild();
                    IngredientComponent ingredientComponent = (IngredientComponent)ingredientComponentListEntry.getKey();
                    ingredientInstance.putString("ingredientComponent", IngredientComponent.REGISTRY.getKey((Object)ingredientComponent).toString());
                    ValueOutput.ValueOutputList instances = ingredientInstance.childrenList("instances");
                    IIngredientSerializer serializer = ingredientComponent.getSerializer();
                    for (IPrototypedIngredient prototypedIngredient : (List)ingredientComponentListEntry.getValue()) {
                        ValueOutput instance = instances.addChild();
                        serializer.serializeInstance(instance.child("prototype"), prototypedIngredient.getPrototype());
                        instance.store("condition", ExtraCodecs.NBT, (Object)serializer.serializeCondition(prototypedIngredient.getCondition()));
                    }
                }
            }
        }
        ValueOutput.ValueOutputList pendingCraftingJobs = valueOutput.childrenList("pendingCraftingJobs");
        for (Object craftingJob : this.pendingCraftingJobs.values()) {
            CraftingJob.serialize(pendingCraftingJobs.addChild(), (CraftingJob)craftingJob);
        }
        ValueOutput.ValueOutputList targetOverrides = valueOutput.childrenList("targetOverrides");
        for (Map.Entry entry : this.ingredientComponentTargetOverrides.entrySet()) {
            ValueOutput entryTag = targetOverrides.addChild();
            entryTag.putString("key", ((IngredientComponent)entry.getKey()).getName().toString());
            entryTag.putInt("value", ((Direction)entry.getValue()).ordinal());
        }
        ValueOutput.ValueOutputList nonBlockingJobsRunningAmount = valueOutput.childrenList("nonBlockingJobsRunningAmount");
        for (Int2IntMap.Entry entry : this.nonBlockingJobsRunningAmount.int2IntEntrySet()) {
            ValueOutput entryTag = nonBlockingJobsRunningAmount.addChild();
            entryTag.putInt("key", entry.getIntKey());
            entryTag.putInt("value", entry.getIntValue());
        }
    }

    public void deserialize(ValueInput valueInput) {
        ValueInput.ValueInputList processingCraftingJobs = (ValueInput.ValueInputList)valueInput.childrenList("processingCraftingJobs").orElseThrow();
        for (ValueInput entryTag : processingCraftingJobs) {
            ArrayList pendingIngredientInstanceEntries = Lists.newArrayList();
            ValueInput.ValueInputList ingredientsEntries = (ValueInput.ValueInputList)entryTag.childrenList("pendingIngredientInstanceEntries").orElseThrow();
            for (ValueInput ingredientEntry : ingredientsEntries) {
                ValueInput.ValueInputList pendingIngredientsList = (ValueInput.ValueInputList)ingredientEntry.childrenList("v").orElseThrow();
                IdentityHashMap pendingIngredientInstances = Maps.newIdentityHashMap();
                for (ValueInput pendingIngredientTag : pendingIngredientsList) {
                    String componentName = (String)pendingIngredientTag.getString("ingredientComponent").orElseThrow();
                    IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)componentName));
                    if (ingredientComponent == null) {
                        throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
                    }
                    IIngredientSerializer serializer = ingredientComponent.getSerializer();
                    ArrayList pendingIngredients = Lists.newArrayList();
                    for (ValueInput instanceTag : (ValueInput.ValueInputList)pendingIngredientTag.childrenList("instances").orElseThrow()) {
                        Object instance = serializer.deserializeInstance((ValueInput)instanceTag.child("prototype").orElseThrow());
                        Object condition = serializer.deserializeCondition((Tag)instanceTag.read("condition", ExtraCodecs.NBT).orElseThrow());
                        pendingIngredients.add(new PrototypedIngredient(ingredientComponent, instance, condition));
                    }
                    pendingIngredientInstances.put(ingredientComponent, pendingIngredients);
                }
                pendingIngredientInstanceEntries.add(pendingIngredientInstances);
            }
            CraftingJob craftingJob = CraftingJob.deserialize((ValueInput)entryTag.child("craftingJob").orElseThrow());
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), (Object)pendingIngredientInstanceEntries);
        }
        for (ValueInput craftingJob : (ValueInput.ValueInputList)valueInput.childrenList("pendingCraftingJobs").orElseThrow()) {
            CraftingJob craftingJobInstance = CraftingJob.deserialize(craftingJob);
            this.pendingCraftingJobs.put(craftingJobInstance.getId(), (Object)craftingJobInstance);
            this.allCraftingJobs.put(craftingJobInstance.getId(), (Object)craftingJobInstance);
        }
        for (List valueEntries : this.processingCraftingJobsPendingIngredients.values()) {
            for (Map value : valueEntries) {
                this.observersPendingCreation.addAll(value.keySet());
            }
        }
        this.ingredientComponentTargetOverrides.clear();
        for (ValueInput targetOverride : (ValueInput.ValueInputList)valueInput.childrenList("targetOverrides").orElseThrow()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)((String)targetOverride.getString("key").orElseThrow())));
            this.ingredientComponentTargetOverrides.put(component, Direction.values()[(Integer)targetOverride.getInt("value").orElseThrow()]);
        }
        this.nonBlockingJobsRunningAmount.clear();
        for (ValueInput job : (ValueInput.ValueInputList)valueInput.childrenList("nonBlockingJobsRunningAmount").orElseThrow()) {
            int craftingJobId = (Integer)job.getInt("key").orElseThrow();
            int amount = (Integer)job.getInt("value").orElseThrow();
            this.nonBlockingJobsRunningAmount.put(craftingJobId, amount);
        }
    }

    public boolean setBlockingJobsMode(boolean blockingJobsMode) {
        if (this.blockingJobsMode != blockingJobsMode) {
            this.blockingJobsMode = blockingJobsMode;
            return true;
        }
        return false;
    }

    public boolean isBlockingJobsMode() {
        return this.blockingJobsMode;
    }

    public boolean canScheduleCraftingJobs() {
        return this.pendingCraftingJobs.size() < GeneralConfig.maxPendingCraftingJobs;
    }

    public void scheduleCraftingJob(CraftingJob craftingJob) {
        this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        if (!this.isBlockingJobsMode()) {
            this.nonBlockingJobsRunningAmount.put(craftingJob.getId(), 0);
        }
    }

    public Int2ObjectMap<List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>>> getProcessingCraftingJobsPendingIngredients() {
        return this.processingCraftingJobsPendingIngredients;
    }

    public Int2ObjectMap<CraftingJob> getProcessingCraftingJobsRaw() {
        return this.processingCraftingJobs;
    }

    public Collection<CraftingJob> getProcessingCraftingJobs() {
        return this.getProcessingCraftingJobsRaw().values();
    }

    public Collection<CraftingJob> getPendingCraftingJobs() {
        return this.pendingCraftingJobs.values();
    }

    public void unmarkCraftingJobProcessing(CraftingJob craftingJob) {
        if (this.processingCraftingJobs.remove(craftingJob.getId()) != null) {
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
            this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        }
    }

    public void addCraftingJobProcessingPendingIngredientsEntry(CraftingJob craftingJob, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> pendingIngredients) {
        if (pendingIngredients.isEmpty()) {
            this.processingCraftingJobs.remove(craftingJob.getId());
            this.allCraftingJobs.remove(craftingJob.getId());
            this.nonBlockingJobsRunningAmount.remove(craftingJob.getId());
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
        } else {
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            List pendingIngredientsEntries = (List)this.processingCraftingJobsPendingIngredients.get(craftingJob.getId());
            if (pendingIngredientsEntries == null) {
                pendingIngredientsEntries = Lists.newArrayList();
                this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), (Object)pendingIngredientsEntries);
            }
            pendingIngredientsEntries.add(pendingIngredients);
        }
    }

    public List<IngredientComponent<?, ?>> getObserversPendingDeletion() {
        return this.observersPendingDeletion;
    }

    protected <T, M> void registerIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
            ICraftingNetwork craftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            PendingCraftingJobResultIndexObserver<T, M> observer = new PendingCraftingJobResultIndexObserver<T, M>(ingredientComponent, this, craftingNetwork);
            ingredientsNetwork.addObserver(observer);
            ingredientsNetwork.scheduleObservation();
            this.ingredientObservers.put(ingredientComponent, observer);
        }
        this.ingredientObserverCounters.put(ingredientComponent, count + 1);
    }

    protected <T, M> void unregisterIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        this.ingredientObserverCounters.put(ingredientComponent, --count);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
            IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?> observer = this.ingredientObservers.remove(ingredientComponent);
            ingredientsNetwork.removeObserver(observer);
        }
    }

    public void onCraftingJobFinished(CraftingJob craftingJob) {
        this.processingCraftingJobs.remove(craftingJob.getId());
        this.pendingCraftingJobs.remove(craftingJob.getId());
        this.finishedCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public void markCraftingJobFinished(int craftingJobId) {
        this.processingCraftingJobsPendingIngredients.remove(craftingJobId);
        this.processingCraftingJobs.remove(craftingJobId);
        this.pendingCraftingJobs.remove(craftingJobId);
        CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
        this.finishedCraftingJobs.put(craftingJobId, (Object)craftingJob);
        craftingJob.setAmount(0);
    }

    public void reRegisterObservers(INetwork network) {
        for (Map.Entry<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> entry : this.ingredientObservers.entrySet()) {
            IPositionedAddonsNetworkIngredients<?, ?> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, entry.getKey());
            ingredientsNetwork.addObserver(entry.getValue());
        }
    }

    public void onCraftingJobEntryFinished(ICraftingNetwork craftingNetwork, int craftingJobId) {
        CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
        craftingJob.setAmount(craftingJob.getAmount() - 1);
        if (this.nonBlockingJobsRunningAmount.containsKey(craftingJobId)) {
            this.nonBlockingJobsRunningAmount.put(craftingJobId, this.nonBlockingJobsRunningAmount.get(craftingJobId) - 1);
        }
        for (CraftingJob dependent : craftingNetwork.getCraftingJobDependencyGraph().getDependents(craftingJob)) {
            dependent.setIgnoreDependencyCheck(true);
        }
    }

    public void update(INetwork network, int channel, PartPos targetPos) {
        int processingJobs;
        if (this.observersPendingCreation.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingCreation) {
                this.registerIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingCreation.clear();
        }
        if (this.observersPendingDeletion.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingDeletion) {
                this.unregisterIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingDeletion.clear();
        }
        if (this.finishedCraftingJobs.size() > 0) {
            for (Object finishedCraftingJob : this.finishedCraftingJobs.values()) {
                if (((CraftingJob)finishedCraftingJob).getAmount() == 0) {
                    ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
                    iCraftingNetwork.onCraftingJobFinished((CraftingJob)finishedCraftingJob);
                    this.allCraftingJobs.remove(((CraftingJob)finishedCraftingJob).getId());
                    this.nonBlockingJobsRunningAmount.remove(((CraftingJob)finishedCraftingJob).getId());
                    continue;
                }
                this.pendingCraftingJobs.put(((CraftingJob)finishedCraftingJob).getId(), finishedCraftingJob);
            }
            this.finishedCraftingJobs.clear();
        }
        if ((processingJobs = this.getProcessingCraftingJobs().size()) > 0) {
            for (IngredientComponent ingredientComponent : this.ingredientObservers.keySet()) {
                IPositionedAddonsNetworkIngredients ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
                ingredientsNetwork.scheduleObservation();
            }
        }
        if (!this.nonBlockingJobsRunningAmount.isEmpty()) {
            for (Int2IntMap.Entry entry : this.nonBlockingJobsRunningAmount.int2IntEntrySet()) {
                int craftingJobId = entry.getIntKey();
                int runningAmount = entry.getIntValue();
                CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
                if (runningAmount <= 0 || runningAmount >= craftingJob.getAmount()) continue;
                this.insertLoopNonBlocking(network, channel, targetPos, craftingJob);
            }
        }
        if (processingJobs < this.maxProcessingJobs) {
            CraftingJob startingCraftingJob = null;
            ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            CraftingJobDependencyGraph dependencyGraph = iCraftingNetwork.getCraftingJobDependencyGraph();
            for (CraftingJob craftingJob : this.getPendingCraftingJobs()) {
                if (dependencyGraph.hasDependencies(craftingJob) && !craftingJob.isIgnoreDependencyCheck()) continue;
                if (craftingJob.isIgnoreDependencyCheck()) {
                    craftingJob.setIgnoreDependencyCheck(false);
                }
                IRecipeDefinition recipe = craftingJob.getRecipe();
                Pair<Map<IngredientComponent<?, ?>, List<?>>, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>>> inputs = CraftingHelpers.getRecipeInputs(CraftingHelpers.getNetworkStorageGetter(network, craftingJob.getChannel(), false), recipe, true, Maps.newIdentityHashMap(), Maps.newIdentityHashMap(), true, 1L);
                if (((Map)inputs.getRight()).isEmpty()) {
                    if (this.insertCrafting(targetPos, (IMixedIngredients)new MixedIngredients((Map)inputs.getLeft()), recipe, network, channel, true)) {
                        startingCraftingJob = craftingJob;
                        startingCraftingJob.setInvalidInputs(false);
                        break;
                    }
                    craftingJob.setInvalidInputs(true);
                    continue;
                }
                if (craftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent component : ((Map)inputs.getRight()).keySet()) {
                        this.registerIngredientObserver(component, network);
                        MissingIngredients missingIngredients = (MissingIngredients)((Map)inputs.getRight()).get(component);
                        block7: for (MissingIngredients.Element element : missingIngredients.getElements()) {
                            if (!element.isInputReusable()) continue;
                            for (MissingIngredients.PrototypedWithRequested alternative : element.getAlternatives()) {
                                if (CraftingHelpers.isCrafting(iCraftingNetwork, channel, alternative.getRequestedPrototype().getComponent(), alternative.getRequestedPrototype().getPrototype(), alternative.getRequestedPrototype().getCondition())) break;
                                CraftingJob craftingJob2 = CraftingHelpers.calculateAndScheduleCraftingJob(network, channel, alternative.getRequestedPrototype().getComponent(), alternative.getRequestedPrototype().getPrototype(), alternative.getRequestedPrototype().getCondition(), true, true, CraftingHelpers.getGlobalCraftingJobIdentifier(), null);
                                if (craftingJob2 == null) continue;
                                craftingJob.addDependency(craftingJob2);
                                continue block7;
                            }
                        }
                    }
                }
                craftingJob.setLastMissingIngredients((Map)inputs.getRight());
            }
            if (startingCraftingJob != null) {
                boolean blockingMode;
                boolean bl;
                if (!startingCraftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent ingredientComponent : startingCraftingJob.getLastMissingIngredients().keySet()) {
                        this.unregisterIngredientObserver(ingredientComponent, network);
                    }
                    startingCraftingJob.setLastMissingIngredients(Maps.newIdentityHashMap());
                }
                if ((bl = this.consumeAndInsertCrafting(blockingMode = !this.nonBlockingJobsRunningAmount.containsKey(startingCraftingJob.getId()) || startingCraftingJob.getAmount() == 1, network, channel, targetPos, startingCraftingJob)) && !blockingMode) {
                    this.nonBlockingJobsRunningAmount.put(startingCraftingJob.getId(), 1);
                    this.insertLoopNonBlocking(network, channel, targetPos, startingCraftingJob);
                }
            }
        }
    }

    protected boolean insertCrafting(PartPos target, IMixedIngredients ingredients, IRecipeDefinition recipe, INetwork network, int channel, boolean simulate) {
        Function<IngredientComponent<?, ?>, PartPos> targetGetter = this.getTargetGetter(target);
        for (ICraftingProcessOverride craftingProcessOverride : this.craftingProcessOverrides) {
            if (!craftingProcessOverride.isApplicable(target)) continue;
            return craftingProcessOverride.craft(targetGetter, ingredients, recipe, this.resultsSink, simulate);
        }
        return CraftingHelpers.insertCrafting(targetGetter, ingredients, network, channel, simulate);
    }

    protected void insertLoopNonBlocking(INetwork network, int channel, PartPos targetPos, CraftingJob craftingJob) {
        while (this.nonBlockingJobsRunningAmount.get(craftingJob.getId()) < craftingJob.getAmount()) {
            IRecipeDefinition recipe = craftingJob.getRecipe();
            IMixedIngredients ingredientsSimulated = CraftingHelpers.getRecipeInputs(network, craftingJob.getChannel(), recipe, true, 1L);
            if (ingredientsSimulated == null || !this.insertCrafting(targetPos, ingredientsSimulated, recipe, network, channel, true) || !this.consumeAndInsertCrafting(true, network, channel, targetPos, craftingJob)) break;
            this.nonBlockingJobsRunningAmount.put(craftingJob.getId(), this.nonBlockingJobsRunningAmount.get(craftingJob.getId()) + 1);
        }
    }

    protected boolean consumeAndInsertCrafting(boolean blockingMode, INetwork network, int channel, PartPos targetPos, CraftingJob startingCraftingJob) {
        IRecipeDefinition recipe = startingCraftingJob.getRecipe();
        IMixedIngredients ingredients = CraftingHelpers.getRecipeInputs(network, startingCraftingJob.getChannel(), recipe, false, 1L);
        if (ingredients != null) {
            this.pendingCraftingJobs.remove(startingCraftingJob.getId());
            this.addCraftingJobProcessingPendingIngredientsEntry(startingCraftingJob, CraftingHelpers.getRecipeOutputs(startingCraftingJob.getRecipe()));
            for (IngredientComponent component : startingCraftingJob.getRecipe().getOutput().getComponents()) {
                this.registerIngredientObserver(component, network);
            }
            if (!this.insertCrafting(targetPos, ingredients, recipe, network, channel, false)) {
                for (IngredientComponent component : startingCraftingJob.getRecipe().getOutput().getComponents()) {
                    this.unregisterIngredientObserver(component, network);
                }
                startingCraftingJob.setInvalidInputs(true);
                this.unmarkCraftingJobProcessing(startingCraftingJob);
                return false;
            }
            return true;
        }
        IntegratedCrafting.clog(Level.WARN, "Failed to extract ingredients for crafting job " + startingCraftingJob.getId());
        return false;
    }

    public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
        if (this.pendingCraftingJobs.containsKey(craftingJobId)) {
            CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
            if (craftingJob != null && craftingJob.isInvalidInputs()) {
                return CraftingJobStatus.INVALID_INPUTS;
            }
            CraftingJobDependencyGraph dependencyGraph = network.getCraftingJobDependencyGraph();
            if (dependencyGraph.hasDependencies(craftingJobId)) {
                return CraftingJobStatus.PENDING_DEPENDENCIES;
            }
            if (!craftingJob.getLastMissingIngredients().isEmpty()) {
                return CraftingJobStatus.PENDING_INGREDIENTS;
            }
            return CraftingJobStatus.PENDING_INTERFACE;
        }
        if (this.processingCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.PROCESSING;
        }
        if (this.finishedCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.FINISHED;
        }
        return CraftingJobStatus.UNKNOWN;
    }

    public Int2ObjectMap<CraftingJob> getAllCraftingJobs() {
        return this.allCraftingJobs;
    }

    public void setIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent, @Nullable Direction side) {
        if (side == null) {
            this.ingredientComponentTargetOverrides.remove(ingredientComponent);
        } else {
            this.ingredientComponentTargetOverrides.put(ingredientComponent, side);
        }
    }

    @Nullable
    public Direction getIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent) {
        return this.ingredientComponentTargetOverrides.get(ingredientComponent);
    }

    public Function<IngredientComponent<?, ?>, PartPos> getTargetGetter(PartPos defaultPosition) {
        return ingredientComponent -> {
            Direction sideOverride = this.ingredientComponentTargetOverrides.get(ingredientComponent);
            if (sideOverride == null) {
                return defaultPosition;
            }
            return PartPos.of((DimPos)defaultPosition.getPos(), (Direction)sideOverride);
        };
    }
}

