/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class MissingIngredients<T, M> {
    private final List<Element<T, M>> elements;

    public MissingIngredients(List<Element<T, M>> elements) {
        this.elements = elements;
    }

    public List<Element<T, M>> getElements() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        return obj instanceof MissingIngredients && this.getElements().equals(((MissingIngredients)obj).getElements());
    }

    public String toString() {
        return this.getElements().toString();
    }

    public static void serialize(ValueOutput valueOutput, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> ingredients) {
        ValueOutput.ValueOutputList missingIngredientsTagList = valueOutput.childrenList("v");
        for (Map.Entry<IngredientComponent<?, ?>, MissingIngredients<?, ?>> entry : ingredients.entrySet()) {
            ValueOutput missingIngredientsTag = missingIngredientsTagList.addChild();
            missingIngredientsTag.putString("component", entry.getKey().toString());
            ValueOutput.ValueOutputList elements = missingIngredientsTag.childrenList("elements");
            for (Element<?, ?> element : entry.getValue().getElements()) {
                ValueOutput elementsTag = elements.addChild();
                ValueOutput.ValueOutputList alternatives = elementsTag.childrenList("alternatives");
                for (PrototypedWithRequested<?, ?> alternative : element.getAlternatives()) {
                    ValueOutput alternativeTag = alternatives.addChild();
                    IPrototypedIngredient.serialize((ValueOutput)alternativeTag.child("requestedPrototype"), alternative.getRequestedPrototype());
                    alternativeTag.putLong("quantityMissing", alternative.getQuantityMissing());
                }
                elementsTag.putBoolean("inputReusable", element.isInputReusable());
            }
        }
    }

    public static Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> deserialize(ValueInput valueInput) throws IllegalArgumentException {
        IdentityHashMap map = Maps.newIdentityHashMap();
        ValueInput.ValueInputList missingIngredientsTagList = (ValueInput.ValueInputList)valueInput.childrenList("v").orElseThrow();
        for (ValueInput input : missingIngredientsTagList) {
            String componentName = (String)input.getString("component").orElseThrow();
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            ArrayList elements = Lists.newArrayList();
            ValueInput.ValueInputList missingIngredientsTag = (ValueInput.ValueInputList)input.childrenList("elements").orElseThrow();
            for (ValueInput elementsTag : missingIngredientsTag) {
                ArrayList alternatives = Lists.newArrayList();
                for (ValueInput alternativeTag : (ValueInput.ValueInputList)elementsTag.childrenList("alternatives").orElseThrow()) {
                    PrototypedIngredient requestedPrototype = IPrototypedIngredient.deserialize((ValueInput)((ValueInput)alternativeTag.child("requestedPrototype").orElseThrow()));
                    long quantityMissing = (Long)alternativeTag.getLong("quantityMissing").orElseThrow();
                    alternatives.add(new PrototypedWithRequested(requestedPrototype, quantityMissing));
                }
                boolean inputReusable = elementsTag.getBooleanOr("inputReusable", false);
                elements.add(new Element(alternatives, inputReusable));
            }
            MissingIngredients missingIngredients = new MissingIngredients(elements);
            map.put(component, missingIngredients);
        }
        return map;
    }

    public static class Element<T, M> {
        private final List<PrototypedWithRequested<T, M>> alternatives;
        private final boolean inputReusable;

        public Element(List<PrototypedWithRequested<T, M>> alternatives, boolean inputReusable) {
            this.alternatives = alternatives;
            this.inputReusable = inputReusable;
        }

        public List<PrototypedWithRequested<T, M>> getAlternatives() {
            return this.alternatives;
        }

        public boolean isInputReusable() {
            return this.inputReusable;
        }

        public boolean equals(Object obj) {
            return obj instanceof Element && this.getAlternatives().equals(((Element)obj).getAlternatives()) && this.isInputReusable() == ((Element)obj).isInputReusable();
        }

        public int hashCode() {
            int result = this.alternatives.hashCode();
            result = 31 * result + Boolean.hashCode(this.inputReusable);
            return result;
        }

        public String toString() {
            return this.getAlternatives().toString() + "::" + this.isInputReusable();
        }
    }

    public static class PrototypedWithRequested<T, M> {
        private final IPrototypedIngredient<T, M> requestedPrototype;
        private final long quantityMissing;

        public PrototypedWithRequested(IPrototypedIngredient<T, M> requestedPrototype, long quantityMissing) {
            this.requestedPrototype = requestedPrototype;
            this.quantityMissing = quantityMissing;
        }

        public IPrototypedIngredient<T, M> getRequestedPrototype() {
            return this.requestedPrototype;
        }

        public long getQuantityMissing() {
            return this.quantityMissing;
        }

        public boolean equals(Object obj) {
            return obj instanceof PrototypedWithRequested && this.getRequestedPrototype().equals(((PrototypedWithRequested)obj).getRequestedPrototype()) && this.getQuantityMissing() == ((PrototypedWithRequested)obj).getQuantityMissing();
        }

        public int hashCode() {
            int result = this.requestedPrototype.hashCode();
            result = 31 * result + Long.hashCode(this.quantityMissing);
            return result;
        }

        public String toString() {
            return String.format("[Prototype: %s; missing: %s]", this.getRequestedPrototype(), this.getQuantityMissing());
        }
    }
}

