/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StonecutterBlock;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.IMinecraftHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingProcessOverrideCraftingTable;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideStonecutter
implements ICraftingProcessOverride {
    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getLevel(true).getBlockState(target.getPos().getBlockPos()).getBlock() instanceof StonecutterBlock;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, IRecipeDefinition recipe, ICraftingResultsSink resultsSink, boolean simulate) {
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        List itemStacks = ingredients.getInstances(IngredientComponent.ITEMSTACK);
        if (itemStacks == null || itemStacks.size() != 1) {
            throw new IllegalArgumentException("Can only craft in a grid with 1 item, while got" + String.valueOf(itemStacks == null ? "null" : Integer.valueOf(itemStacks.size())));
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput((ItemStack)itemStacks.get(0));
        ServerLevel level = (ServerLevel)target.getPos().getLevel(true);
        IMixedIngredients output = recipe.getOutput();
        List recipeOutputs = output.getInstances(IngredientComponent.ITEMSTACK);
        if (output.getComponents().size() != 1 || recipeOutputs.size() != 1) {
            throw new IllegalArgumentException("Can only craft for an output of 1 item, while got" + String.valueOf(recipeOutputs == null ? "null" : Integer.valueOf(recipeOutputs.size())));
        }
        ItemStack recipeOutput = (ItemStack)recipeOutputs.getFirst();
        IMinecraftHelpers mcHelpers = IModHelpers.get().getMinecraftHelpers();
        return IModHelpers.get().getCraftingHelpers().findRecipes(level, RecipeType.STONECUTTING).stream().filter(recipeHolder -> ((StonecutterRecipe)recipeHolder.value()).matches(recipeInput, (Level)level) && ItemStack.isSameItemSameComponents((ItemStack)mcHelpers.getRecipeOutput(recipeHolder, (Level)level), (ItemStack)recipeOutput)).findFirst().map(recipeHolder -> {
            StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)recipeHolder.value();
            ItemStack result = stonecutterRecipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
            if (result.isEmpty()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((ServerLevel)target.getPos().getLevel(true));
                result.onCraftedBy((Player)player, 1);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
            }
            return true;
        }).orElse(false);
    }
}

