/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.persist.world.GlobalCounters;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.RegistryEntries;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverrideRegistry;
import org.cyclops.integratedcrafting.capability.network.CraftingNetworkCapabilityConstructors;
import org.cyclops.integratedcrafting.capability.network.NetworkCraftingHandlerCraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingProcessOverrideRegistry;
import org.cyclops.integratedcrafting.core.CraftingProcessOverrides;
import org.cyclops.integratedcrafting.gametest.GameTestsItemsCraft;
import org.cyclops.integratedcrafting.gametest.GameTestsItemsSmithing;
import org.cyclops.integratedcrafting.gametest.GameTestsItemsStonecutting;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingConfig;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettingsConfig;
import org.cyclops.integratedcrafting.part.PartTypes;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspects;
import org.cyclops.integratedcrafting.proxy.ClientProxy;
import org.cyclops.integratedcrafting.proxy.CommonProxy;
import org.cyclops.integratedcrafting.recipe.type.RecipeSerializerDeadBushConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetworkCraftingHandler;
import org.cyclops.integrateddynamics.api.network.INetworkCraftingHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.event.IntegratedDynamicsSetupEvent;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

@Mod(value="integratedcrafting")
public class IntegratedCrafting
extends ModBaseNeoForge<IntegratedCrafting> {
    public static IntegratedCrafting _instance;
    public static GlobalCounters.Access globalCounters;

    public IntegratedCrafting(IEventBus modEventBus) {
        super("integratedcrafting", instance -> {
            _instance = instance;
        }, modEventBus);
        this.getRegistryManager().addRegistry(ICraftingProcessOverrideRegistry.class, (IRegistry)CraftingProcessOverrideRegistry.getInstance());
        globalCounters = new GlobalCounters.Access((ModBaseNeoForge)this);
        this.registerWorldStorage((WorldStorage.Access)globalCounters);
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(this::onSetup);
        modEventBus.register((Object)new CraftingNetworkCapabilityConstructors());
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        CraftingAspects.load();
        PartTypes.load();
        CraftingProcessOverrides.load();
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
    }

    protected void onSetup(IntegratedDynamicsSetupEvent event) {
        Aspects.REGISTRY.register((IPartType)org.cyclops.integrateddynamics.core.part.PartTypes.NETWORK_READER, (Collection)Lists.newArrayList((Object[])new IAspect[]{CraftingAspects.Read.Network.RECIPES, CraftingAspects.Read.Network.CRAFTING_JOBS, CraftingAspects.Read.Network.CRAFTING_INGREDIENTS}));
        ((INetworkCraftingHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(INetworkCraftingHandlerRegistry.class)).register((INetworkCraftingHandler)new NetworkCraftingHandlerCraftingNetwork());
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedcrafting/info/crafting_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedcrafting/info/crafting_tutorials.xml");
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_PART_INTERFACE_CRAFTING));
    }

    public void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerPartInterfaceCraftingConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerPartInterfaceCraftingSettingsConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new RecipeSerializerDeadBushConfig());
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[]{GameTestsItemsCraft.class, GameTestsItemsSmithing.class, GameTestsItemsStonecutting.class};
    }

    public static void clog(String message) {
        IntegratedCrafting.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }

    static {
        globalCounters = null;
    }
}

