/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.api.crafting;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.core.CraftingHelpers;

public class CraftingJobDependencyGraph {
    private final Int2ObjectMap<CraftingJob> craftingJobs;
    private final Int2ObjectMap<IntCollection> dependencies;
    private final Int2ObjectMap<IntCollection> dependents;

    public CraftingJobDependencyGraph() {
        this((Int2ObjectMap<CraftingJob>)new Int2ObjectOpenHashMap(), (Int2ObjectMap<IntCollection>)new Int2ObjectOpenHashMap(), (Int2ObjectMap<IntCollection>)new Int2ObjectOpenHashMap());
    }

    public CraftingJobDependencyGraph(Int2ObjectMap<CraftingJob> craftingJobs, Int2ObjectMap<IntCollection> dependencies, Int2ObjectMap<IntCollection> dependents) {
        this.craftingJobs = craftingJobs;
        this.dependencies = dependencies;
        this.dependents = dependents;
    }

    public Collection<CraftingJob> getCraftingJobs() {
        return this.craftingJobs.values();
    }

    @Nullable
    public CraftingJob getCraftingJob(int id) {
        return (CraftingJob)this.craftingJobs.get(id);
    }

    public Collection<CraftingJob> getDependencies(CraftingJob craftingJob) {
        return ((IntCollection)this.dependencies.getOrDefault(craftingJob.getId(), (Object)new IntArrayList())).stream().map(arg_0 -> this.craftingJobs.get(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasDependencies(CraftingJob craftingJob) {
        return this.hasDependencies(craftingJob.getId());
    }

    public boolean hasDependencies(int craftingJobId) {
        IntCollection deps = (IntCollection)this.dependencies.get(craftingJobId);
        if (deps != null) {
            IntIterator it = deps.iterator();
            while (it.hasNext()) {
                if (this.craftingJobs.get((Object)it.next()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<CraftingJob> getDependents(CraftingJob craftingJob) {
        return ((IntCollection)this.dependents.getOrDefault(craftingJob.getId(), (Object)new IntArrayList())).stream().map(arg_0 -> this.craftingJobs.get(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void addCraftingJobId(CraftingJob craftingJob) {
        this.craftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public void removeCraftingJobId(CraftingJob craftingJob) {
        this.craftingJobs.remove(craftingJob.getId());
    }

    public void onCraftingJobFinished(CraftingJob craftingJob) {
        this.onCraftingJobFinished(craftingJob, false);
    }

    public void onCraftingJobFinished(CraftingJob craftingJob, boolean finishInvalidDependencies) {
        IntCollection removedDependencies;
        this.removeCraftingJobId(craftingJob);
        IntCollection removed = (IntCollection)this.dependents.remove(craftingJob.getId());
        craftingJob.getDependentCraftingJobs().clear();
        if (removed != null) {
            IntIterator removedIt = removed.iterator();
            while (removedIt.hasNext()) {
                int dependent = removedIt.nextInt();
                IntCollection dependentDependencies = (IntCollection)this.dependencies.get(dependent);
                dependentDependencies.rem(craftingJob.getId());
                CraftingJob dependentJob = (CraftingJob)this.craftingJobs.get(dependent);
                if (dependentJob == null) continue;
                dependentJob.getDependencyCraftingJobs().rem(craftingJob.getId());
                if (!dependentDependencies.isEmpty()) continue;
                this.dependencies.remove(dependent);
                if (this.dependents.containsKey(dependent)) continue;
                this.craftingJobs.remove(dependent);
            }
        }
        if ((removedDependencies = (IntCollection)this.dependencies.remove(craftingJob.getId())) != null) {
            IntIterator removedDependenciesIt = removedDependencies.iterator();
            while (removedDependenciesIt.hasNext()) {
                int dependency = removedDependenciesIt.nextInt();
                this.dependents.remove(dependency);
                if (!finishInvalidDependencies) continue;
                this.onCraftingJobFinished((CraftingJob)this.craftingJobs.get(dependency), true);
            }
        }
    }

    public void addDependency(CraftingJob craftingJob, CraftingJob dependency) {
        this.addCraftingJobId(dependency);
        this.addDependency(craftingJob, dependency.getId());
    }

    public void addDependency(CraftingJob craftingJob, int dependency) {
        this.addCraftingJobId(craftingJob);
        IntCollection jobDependencies = (IntCollection)this.dependencies.get(craftingJob.getId());
        if (jobDependencies == null) {
            jobDependencies = new IntArrayList();
            this.dependencies.put(craftingJob.getId(), (Object)jobDependencies);
        }
        jobDependencies.add(dependency);
        IntCollection jobDependents = (IntCollection)this.dependents.get(dependency);
        if (jobDependents == null) {
            jobDependents = new IntArrayList();
            this.dependents.put(dependency, (Object)jobDependents);
        }
        jobDependents.add(craftingJob.getId());
    }

    public void removeDependency(int craftingJob, int dependency) {
        IntCollection jobDependents;
        IntCollection jobDependencies = (IntCollection)this.dependencies.get(craftingJob);
        if (jobDependencies != null) {
            jobDependencies.rem(dependency);
            if (jobDependencies.isEmpty()) {
                this.dependencies.remove(craftingJob);
                if (!this.dependents.containsKey(craftingJob)) {
                    this.craftingJobs.remove(craftingJob);
                }
            }
        }
        if ((jobDependents = (IntCollection)this.dependents.get(dependency)) != null) {
            jobDependents.rem(craftingJob);
            if (jobDependents.isEmpty()) {
                this.dependents.remove(dependency);
                if (!this.dependencies.containsKey(dependency)) {
                    this.craftingJobs.remove(dependency);
                }
            }
        }
    }

    public void importDependencies(CraftingJobDependencyGraph craftingJobsGraph) {
        for (CraftingJob craftingJob : craftingJobsGraph.getCraftingJobs()) {
            for (CraftingJob dependency : craftingJobsGraph.getDependencies(craftingJob)) {
                this.addDependency(craftingJob, dependency);
            }
        }
    }

    public void mergeCraftingJobs(CraftingJob target, CraftingJob mergee, boolean markMergeeAsFinished) {
        CraftingJob dependencyCraftingJob;
        target.setAmount(target.getAmount() + mergee.getAmount());
        target.setIngredientsStorage(CraftingHelpers.mergeMixedIngredients(target.getIngredientsStorage(), mergee.getIngredientsStorage()));
        HashMap dependencyRecipeJobs = Maps.newHashMap();
        for (Integer dependencyCraftingJobId : target.getDependencyCraftingJobs()) {
            dependencyCraftingJob = this.getCraftingJob(dependencyCraftingJobId);
            dependencyRecipeJobs.put(dependencyCraftingJob.getRecipe(), dependencyCraftingJob);
        }
        for (Integer dependencyCraftingJobId : mergee.getDependencyCraftingJobs()) {
            dependencyCraftingJob = this.getCraftingJob(dependencyCraftingJobId);
            CraftingJob existingDependencyJob = (CraftingJob)dependencyRecipeJobs.get(dependencyCraftingJob.getRecipe());
            if (existingDependencyJob != null) {
                this.mergeCraftingJobs(existingDependencyJob, dependencyCraftingJob, false);
                continue;
            }
            mergee.removeDependency(dependencyCraftingJob);
            target.addDependency(dependencyCraftingJob);
            this.removeDependency(mergee.getId(), dependencyCraftingJobId);
            this.addDependency(target, dependencyCraftingJob);
            dependencyRecipeJobs.put(dependencyCraftingJob.getRecipe(), dependencyCraftingJob);
        }
        if (markMergeeAsFinished) {
            this.onCraftingJobFinished(mergee, true);
        }
    }

    public static void serialize(ValueOutput valueOutput, CraftingJobDependencyGraph graph) {
        ValueOutput.ValueOutputList craftingJobs = valueOutput.childrenList("craftingJobs");
        for (CraftingJob craftingJob : graph.getCraftingJobs()) {
            CraftingJob.serialize(craftingJobs.addChild(), craftingJob);
        }
        ValueOutput.ValueOutputList dependencies = valueOutput.childrenList("dependencies");
        for (CraftingJob craftingJob : graph.getCraftingJobs()) {
            IntCollection intCollection = (IntCollection)graph.dependencies.get(craftingJob.getId());
            if (intCollection == null) continue;
            ValueOutput dependency = dependencies.addChild();
            dependency.putInt("key", craftingJob.getId());
            dependency.putIntArray("values", intCollection.toIntArray());
        }
        ValueOutput.ValueOutputList valueOutputList = valueOutput.childrenList("dependents");
        for (CraftingJob craftingJob : graph.getCraftingJobs()) {
            IntCollection intCollection = (IntCollection)graph.dependents.get(craftingJob.getId());
            if (intCollection == null) continue;
            ValueOutput dependent = valueOutputList.addChild();
            dependent.putInt("key", craftingJob.getId());
            dependent.putIntArray("values", intCollection.toIntArray());
        }
    }

    public static CraftingJobDependencyGraph deserialize(ValueInput valueInput) {
        Int2ObjectOpenHashMap craftingJobs = new Int2ObjectOpenHashMap();
        for (Object input : (ValueInput.ValueInputList)valueInput.childrenList("craftingJobs").orElseThrow()) {
            CraftingJob craftingJob = CraftingJob.deserialize((ValueInput)input);
            craftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        }
        Int2ObjectOpenHashMap dependencies = new Int2ObjectOpenHashMap();
        for (ValueInput input : (ValueInput.ValueInputList)valueInput.childrenList("dependencies").orElseThrow()) {
            int key = (Integer)input.getInt("key").orElseThrow();
            int[] values = (int[])input.getIntArray("values").orElseThrow();
            dependencies.put(key, (Object)new IntArrayList(values));
        }
        Int2ObjectOpenHashMap dependents = new Int2ObjectOpenHashMap();
        for (ValueInput input : (ValueInput.ValueInputList)valueInput.childrenList("dependents").orElseThrow()) {
            int key = (Integer)input.getInt("key").orElseThrow();
            int[] values = (int[])input.getIntArray("values").orElseThrow();
            dependents.put(key, (Object)new IntArrayList(values));
        }
        return new CraftingJobDependencyGraph((Int2ObjectMap<CraftingJob>)craftingJobs, (Int2ObjectMap<IntCollection>)dependencies, (Int2ObjectMap<IntCollection>)dependents);
    }
}

