/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.gametest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedcrafting.core.part.PartTypeInterfaceCraftingBase;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspects;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestHelpersIntegratedCrafting {
    public static INetworkPositions<PartTypeInterfaceCrafting.State> createBasicNetwork(GameTestHelper helper, BlockPos pos) {
        return GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, pos, false);
    }

    public static <T extends PartTypeInterfaceCraftingBase.State<?, ?>> INetworkPositions<T> createBasicNetwork(GameTestHelper helper, BlockPos pos, boolean attuned) {
        return GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, pos, attuned, Blocks.CRAFTING_TABLE);
    }

    public static INetworkPositions<PartTypeInterfaceCrafting.State> createBasicNetwork(GameTestHelper helper, BlockPos pos, Block ... crafters) {
        return GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, pos, false, crafters);
    }

    public static <T extends PartTypeInterfaceCraftingBase.State<?, ?>> INetworkPositions<T> createBasicNetwork(GameTestHelper helper, BlockPos pos, boolean attuned, Block ... crafters) {
        PartTypeInterfaceCraftingBase partInterface = attuned ? org.cyclops.integratedcrafting.part.PartTypes.INTERFACE_CRAFTING_ATTUNED : org.cyclops.integratedcrafting.part.PartTypes.INTERFACE_CRAFTING;
        helper.setBlock(pos, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(pos), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(pos), (Direction)Direction.NORTH, (IPartType)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER, (ItemStack)new ItemStack((ItemLike)org.cyclops.integratedcrafting.part.PartTypes.CRAFTING_WRITER.getItem()));
        helper.setBlock(pos.east(), Blocks.CHEST);
        BlockPos posi = pos;
        ArrayList interfaces = Lists.newArrayList();
        ArrayList interfaceStates = Lists.newArrayList();
        ArrayList interfaceRecipeAdders = Lists.newArrayList();
        for (Block crafter : crafters) {
            if (!pos.equals((Object)posi)) {
                helper.setBlock(posi, (Block)RegistryEntries.BLOCK_CABLE.value());
            }
            helper.setBlock(posi.above(), (Block)RegistryEntries.BLOCK_CABLE.value());
            helper.setBlock(posi.above().west(), (Block)RegistryEntries.BLOCK_CABLE.value());
            PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.above().west()), (Direction)Direction.DOWN, (IPartType)partInterface, (ItemStack)new ItemStack((ItemLike)partInterface.getItem()));
            helper.setBlock(posi.west(), crafter);
            if (crafter == Blocks.FURNACE) {
                helper.setBlock(posi.west(), (BlockState)crafter.defaultBlockState().setValue((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.EAST));
                FurnaceBlockEntity furnace = (FurnaceBlockEntity)helper.getBlockEntity(posi.west(), FurnaceBlockEntity.class);
                furnace.setItem(1, new ItemStack((ItemLike)Items.COAL, 64));
                helper.setBlock(posi.below(), (Block)RegistryEntries.BLOCK_CABLE.value());
                helper.setBlock(posi.below().west(), (Block)RegistryEntries.BLOCK_CABLE.value());
                PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.below().west()), (Direction)Direction.UP, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
                GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.below().west()), (Direction)Direction.UP), (IAspectWrite)TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
            }
            interfaces.add(PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.above().west()), (Direction)Direction.DOWN));
            PartTypeInterfaceCraftingBase.State partStateCraftingInterface = (PartTypeInterfaceCraftingBase.State)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(posi.above().west()), (Direction)Direction.DOWN)).getState();
            interfaceStates.add(partStateCraftingInterface);
            interfaceRecipeAdders.add(pair -> {
                ItemStack variableRecipe = GameTestHelpersIntegratedCrafting.createVariableForRecipe((Level)helper.getLevel(), (RecipeType)pair.getMiddle(), (ResourceLocation)pair.getRight());
                if (partStateCraftingInterface instanceof PartTypeInterfaceCrafting.State) {
                    PartTypeInterfaceCrafting.State partStateCraftingInterfaceRegular = (PartTypeInterfaceCrafting.State)partStateCraftingInterface;
                    partStateCraftingInterfaceRegular.getInventoryVariables().setItem(((Integer)pair.getLeft()).intValue(), variableRecipe);
                }
            });
            posi = posi.south();
        }
        return new NetworkPositions(pos.east(), PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(pos), (Direction)Direction.NORTH), interfaces, interfaceStates, interfaceRecipeAdders);
    }

    public static ItemStack createVariableForRecipe(Level level, RecipeType<?> recipeType, ResourceLocation recipeName) {
        RecipeHolder recipeUnknown = null;
        RecipeDisplay recipeDisplay = null;
        try {
            ResourceKey recipeKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeName);
            recipeUnknown = (RecipeHolder)IModHelpers.get().getCraftingHelpers().getRecipe(recipeType, recipeKey).orElseThrow(() -> new IllegalStateException("Recipe " + recipeName.toString() + " could not be found"));
            recipeDisplay = ((RecipeDisplayEntry)IModHelpers.get().getCraftingHelpers().getRecipeDisplays(recipeType, recipeKey).getFirst()).display();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        IdentityHashMap recipeIn = Maps.newIdentityHashMap();
        ArrayList alternatives = Lists.newArrayList();
        IdentityHashMap recipeOut = Maps.newIdentityHashMap();
        ItemStack result = recipeDisplay.result().resolveForFirstStack(SlotDisplayContext.fromLevel((Level)level));
        Object object = recipeUnknown.value();
        if (object instanceof CraftingRecipe) {
            CraftingRecipe recipeCrafting = (CraftingRecipe)object;
            int width = 3;
            int height = 3;
            for (int i = 0; i < width * height; ++i) {
                alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)ItemStack.EMPTY, (Object)5)})));
            }
            List ingredients = recipeCrafting.placementInfo().ingredients();
            PlaceRecipeHelper.placeRecipe((int)width, (int)height, (Recipe)recipeCrafting, (Iterable)recipeCrafting.placementInfo().slotsToIngredientIndex(), (ingredientSlot, slot, x, y) -> {
                String tag = null;
                if (ingredientSlot >= 0 && slot >= 0) {
                    Object patt1$temp;
                    ShapedCraftingRecipeDisplay displayCrafting;
                    ShapelessCraftingRecipeDisplay displayCrafting2;
                    Object patt0$temp;
                    RecipeDisplay display = (RecipeDisplay)recipeCrafting.display().get(0);
                    if (display instanceof ShapelessCraftingRecipeDisplay && (patt0$temp = (displayCrafting2 = (ShapelessCraftingRecipeDisplay)display).ingredients().get((int)ingredientSlot)) instanceof SlotDisplay.TagSlotDisplay) {
                        SlotDisplay.TagSlotDisplay slotTag = (SlotDisplay.TagSlotDisplay)patt0$temp;
                        tag = slotTag.tag().location().toString();
                    } else if (display instanceof ShapedCraftingRecipeDisplay && slot < (displayCrafting = (ShapedCraftingRecipeDisplay)display).ingredients().size() && (patt1$temp = displayCrafting.ingredients().get(slot)) instanceof SlotDisplay.TagSlotDisplay) {
                        SlotDisplay.TagSlotDisplay slotTag = (SlotDisplay.TagSlotDisplay)patt1$temp;
                        tag = slotTag.tag().location().toString();
                    }
                }
                if (tag != null) {
                    alternatives.set(slot, new PrototypedIngredientAlternativesItemStackTag((List)Lists.newArrayList((Object[])new String[]{tag}), Integer.valueOf(1), 1L));
                } else {
                    ItemStack itemStack = ingredientSlot < 0 ? ItemStack.EMPTY : new ItemStack((Holder)((Ingredient)ingredients.get((int)ingredientSlot)).items().findFirst().get());
                    alternatives.set(slot, new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)itemStack, (Object)5)})));
                }
            });
            recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
            recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{result}));
        } else {
            object = recipeUnknown.value();
            if (object instanceof SmeltingRecipe) {
                SmeltingRecipe recipeSmelting = (SmeltingRecipe)object;
                for (Ingredient ingredient : recipeSmelting.placementInfo().ingredients()) {
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((Holder)ingredient.items().findFirst().get()), (Object)5)})));
                }
                recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
                recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{result}));
            } else {
                object = recipeUnknown.value();
                if (object instanceof SmithingTransformRecipe) {
                    SmithingTransformRecipe recipeSmithing = (SmithingTransformRecipe)object;
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((Holder)((Ingredient)recipeSmithing.template.get()).items().findFirst().get()), (Object)5)})));
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((Holder)recipeSmithing.base.items().findFirst().get()), (Object)5)})));
                    alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((Holder)((Ingredient)recipeSmithing.addition.get()).items().findFirst().get()), (Object)5)})));
                    recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
                    recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{result}));
                } else {
                    object = recipeUnknown.value();
                    if (object instanceof StonecutterRecipe) {
                        StonecutterRecipe recipeStoneCutter = (StonecutterRecipe)object;
                        for (Ingredient ingredient : recipeStoneCutter.placementInfo().ingredients()) {
                            alternatives.add(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.ITEMSTACK, (Object)new ItemStack((Holder)ingredient.items().findFirst().get()), (Object)5)})));
                        }
                        recipeIn.put(IngredientComponents.ITEMSTACK, alternatives);
                        recipeOut.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{result}));
                    } else {
                        throw new IllegalStateException("Unknown recipe type " + String.valueOf(recipeType));
                    }
                }
            }
        }
        return GameTestHelpersIntegratedDynamics.createVariableForValue((Level)level, (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)recipeIn, (IMixedIngredients)new MixedIngredients((Map)recipeOut))));
    }

    public static void enableRecipeInWriter(GameTestHelper helper, PartPos writerPos, ItemStack itemStack) {
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)writerPos, CraftingAspects.Write.ITEMSTACK_CRAFT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)itemStack)));
    }

    public static <T extends IValueType<V>, V extends IValue> void setWriterAspectProperty(PartPos writerPos, IAspectWrite aspect, IAspectPropertyTypeInstance<T, V> type, V value) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)writerPos);
        IAspectProperties properties = aspect.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)writerPos), partStateHolder.getState());
        properties.setValue(type, value);
        partStateHolder.getState().setAspectProperties((IAspect)aspect, properties);
    }

    public static <T extends IValueType<V>, V extends IValue> void setCraftingInterfaceBlockingMode(PartPos writerPos, boolean blocking) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)writerPos);
        ((PartTypeInterfaceCrafting.State)partStateHolder.getState()).getCraftingJobHandler().setBlockingJobsMode(blocking);
    }

    public static <T extends IValueType<V>, V extends IValue> void setCraftingInterfaceUpdateInterval(PartPos writerPos, int updateInterval) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)writerPos);
        partStateHolder.getState().setUpdateInterval(updateInterval);
    }

    public static interface INetworkPositions<T extends PartTypeInterfaceCraftingBase.State<?, ?>> {
        public BlockPos chest();

        public PartPos writer();

        public List<PartPos> interfaces();

        public List<T> interfaceStates();

        public List<Consumer<Triple<Integer, RecipeType<?>, ResourceLocation>>> interfaceRecipeAdders();
    }

    public record NetworkPositions<T extends PartTypeInterfaceCraftingBase.State<?, ?>>(BlockPos chest, PartPos writer, List<PartPos> interfaces, List<T> interfaceStates, List<Consumer<Triple<Integer, RecipeType<?>, ResourceLocation>>> interfaceRecipeAdders) implements INetworkPositions<T>
    {
    }
}

