/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integratedcrafting.gametest.GameTestHelpersIntegratedCrafting;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integratedcrafting.part.PartTypes;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspects;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class GameTestsItemsStonecutting {
    public static final String TEMPLATE_EMPTY = "integratedcrafting:empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integratedcrafting:empty10", timeoutTicks=2000)
    public void testItemsStonecuttingCopperGrate(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.INetworkPositions<PartTypeInterfaceCrafting.State> positions = GameTestHelpersIntegratedCrafting.createBasicNetwork(helper, POS, Blocks.STONECUTTER);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.COPPER_BLOCK, 1));
        positions.interfaceRecipeAdders().get(0).accept(Triple.of((Object)0, (Object)RecipeType.STONECUTTING, (Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"copper_grate_from_copper_block_stonecutting")));
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter(helper, positions.writer(), new ItemStack((ItemLike)Items.COPPER_GRATE));
        helper.succeedWhen(() -> {
            helper.assertTrue(((PartTypeInterfaceCrafting.State)positions.interfaceStates().get(0)).isRecipeSlotValid(0), (Component)Component.literal((String)"Recipe in crafting interface is not valid"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.CRAFTING_WRITER.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), CraftingAspects.Write.ITEMSTACK_CRAFT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(CraftingAspects.Write.ITEMSTACK_CRAFT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)Items.COPPER_GRATE, (Component)Component.literal((String)"Slot 0 item is incorrect"));
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)4, (Component)Component.literal((String)"Slot 0 amount is incorrect"));
        });
    }
}

