/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.api.crafting;

import java.util.List;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;

public class UnknownCraftingRecipeException
extends Exception {
    private final IPrototypedIngredient<?, ?> ingredient;
    private final long quantityMissing;
    private final List<UnknownCraftingRecipeException> missingChildRecipes;
    private final IMixedIngredients ingredientsStorage;
    private final List<CraftingJob> partialCraftingJobs;

    public UnknownCraftingRecipeException(IPrototypedIngredient<?, ?> ingredient, long quantityMissing, List<UnknownCraftingRecipeException> missingChildRecipes, IMixedIngredients ingredientsStorage, List<CraftingJob> partialCraftingJobs) {
        this.ingredient = ingredient;
        this.quantityMissing = quantityMissing;
        this.missingChildRecipes = missingChildRecipes;
        this.ingredientsStorage = ingredientsStorage;
        this.partialCraftingJobs = partialCraftingJobs;
    }

    public IPrototypedIngredient<?, ?> getIngredient() {
        return this.ingredient;
    }

    public long getQuantityMissing() {
        return this.quantityMissing;
    }

    public List<UnknownCraftingRecipeException> getMissingChildRecipes() {
        return this.missingChildRecipes;
    }

    public IMixedIngredients getIngredientsStorage() {
        return this.ingredientsStorage;
    }

    public List<CraftingJob> getPartialCraftingJobs() {
        return this.partialCraftingJobs;
    }

    @Override
    public String getMessage() {
        return String.format("Could not find a recipe for %s (with %s missing, and %s stored, and %s partial), with missing sub-recipes: %s", this.getIngredient(), this.getQuantityMissing(), this.getIngredientsStorage(), this.getPartialCraftingJobs(), this.getMissingChildRecipes());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnknownCraftingRecipeException)) {
            return false;
        }
        UnknownCraftingRecipeException that = (UnknownCraftingRecipeException)obj;
        return this.getIngredient().equals(that.getIngredient()) && this.getQuantityMissing() == that.getQuantityMissing() && this.getMissingChildRecipes().equals(that.getMissingChildRecipes()) && this.getIngredientsStorage().equals((Object)that.getIngredientsStorage()) && this.getPartialCraftingJobs().equals(that.getPartialCraftingJobs());
    }
}

