/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.core.crafting.processoverride.CraftingGrid;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideCraftingTable
implements ICraftingProcessOverride {
    private static GameProfile PROFILE = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BB57-13D2C99CAE77"), "[IntegratedCrafting]");
    private static final Map<ServerLevel, FakePlayer> FAKE_PLAYERS = new WeakHashMap<ServerLevel, FakePlayer>();

    public static FakePlayer getFakePlayer(ServerLevel world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.get(world);
        if (fakePlayer == null) {
            fakePlayer = new FakePlayer(world, PROFILE);
            FAKE_PLAYERS.put(world, fakePlayer);
        }
        return fakePlayer;
    }

    @Override
    public boolean isApplicable(PartPos target) {
        return target.getPos().getLevel(true).m_8055_(target.getPos().getBlockPos()).m_60734_() instanceof CraftingTableBlock;
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, IRecipeDefinition recipe, ICraftingResultsSink resultsSink, boolean simulate) {
        PartPos target = targetGetter.apply(IngredientComponent.ITEMSTACK);
        CraftingGrid grid = new CraftingGrid(ingredients, 3, 3);
        Level level = target.getPos().getLevel(true);
        return CraftingHelpers.findServerRecipe((RecipeType)RecipeType.f_44107_, (Container)grid, (Level)level).or(() -> {
            try {
                CraftingGrid gridSmall = new CraftingGrid(ingredients, 2, 2);
                return CraftingHelpers.findServerRecipe((RecipeType)RecipeType.f_44107_, (Container)gridSmall, (Level)level);
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }).map(craftingRecipe -> {
            ItemStack result = craftingRecipe.m_5874_((Container)grid, level.m_9598_());
            if (result.m_41619_()) {
                return false;
            }
            if (!simulate) {
                FakePlayer player = CraftingProcessOverrideCraftingTable.getFakePlayer((ServerLevel)target.getPos().getLevel(true));
                result.m_41678_(target.getPos().getLevel(true), (Player)player, 1);
                ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)result, (Container)grid);
                resultsSink.addResult(IngredientComponent.ITEMSTACK, result);
                for (ItemStack remainingItem : craftingRecipe.m_7457_((Container)grid)) {
                    if (remainingItem.m_41619_()) continue;
                    resultsSink.addResult(IngredientComponent.ITEMSTACK, remainingItem);
                }
            }
            return true;
        }).orElse(false);
    }
}

