/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxencedc.sparsestructures.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.maxencedc.sparsestructures.Constants;
import io.github.maxencedc.sparsestructures.StructureSetsSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DumpStructureSetsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dumpstructuresets").requires(cs -> cs.hasPermission(2))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.sparsestructures.dump.dumping"), false);
            String fileName = new SimpleDateFormat("'structure_sets_dump_'yy_MM_dd_HH_mm'.txt'").format(new Date());
            try {
                DumpStructureSetsCommand.dumpStructureSets(fileName);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
                    boolean isDedicatedServer = ((CommandSourceStack)context.getSource()).getServer().isDedicatedServer();
                    MutableComponent underlinedFile = Component.literal((String)fileName).withStyle(ChatFormatting.UNDERLINE);
                    Object message = Component.translatable((String)"command.sparsestructures.dump.success", (Object[])new Object[]{underlinedFile}).getString();
                    if (isDedicatedServer) {
                        message = (String)message + "\n" + Component.translatable((String)"command.sparsestructures.dump.server").getString();
                    }
                    return Component.literal((String)message);
                }, false);
                return 1;
            }
            catch (IOException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.sparsestructures.dump.failure"));
                Constants.LOG.error("Failed to dump structure sets\n", (Throwable)e);
                return 0;
            }
        }));
    }

    private static void dumpStructureSets(String fileName) throws IOException {
        Path dumpPath = Path.of("sparsestructures", new String[0]);
        StringBuilder dump = new StringBuilder();
        StructureSetsSet.structureSets.forEach(s -> dump.append("{\n  \"structure\": \"").append((String)s).append("\",\n  \"factor\": 1//REPLACE WITH YOUR CUSTOM SPREADING FACTOR HERE\n},\n"));
        Files.createDirectories(dumpPath, new FileAttribute[0]);
        Files.writeString(dumpPath.resolve(fileName), (CharSequence)dump.toString(), new OpenOption[0]);
    }
}

